#!/usr/bin/env python3
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import AleCliLib
import BasicCliModes
import CliCommand
import CliParser
import CliToken

#-------------------------------------------------------------------------------
# [ no | default ] ip hardware forwarding mpls gre-key
#-------------------------------------------------------------------------------

def greGuard( mode, token ):
   if AleCliLib.routingHwStatus.greKeyForwardingSupported:
      return None
   else:
      return CliParser.guardNotThisPlatform

nodeMpls = CliCommand.guardedKeyword(
   'mpls',
   helpdesc="Configure hardware forwarding based on MPLS",
   guard=greGuard )

def enableGreForwarding( mode, args ):
   AleCliLib.routingHwConfig.greKeyForwarding = True

def disableGreForwarding( mode, args ):
   AleCliLib.routingHwConfig.greKeyForwarding = False

class IpHardwareForwardingMplsGrekeyCmd( CliCommand.CliCommandClass ):
   syntax = 'ip hardware forwarding mpls gre-key'
   noOrDefaultSyntax = syntax
   data = {
         'ip' : CliToken.Ip.ipMatcherForConfig,
         'hardware' : CliToken.Hardware.hardwareMatcherForConfig,
         'forwarding' : 'Forwarding configuration',
         'mpls' : nodeMpls,
         'gre-key' : 'Configure MPLS hardware forwarding using GRE Key as' +
                        'MPLS label',
         }

   handler = enableGreForwarding
   noOrDefaultHandler = disableGreForwarding

BasicCliModes.GlobalConfigMode.addCommandClass( IpHardwareForwardingMplsGrekeyCmd )
