#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliDynamicSymbol import CliDynamicPlugin
import BasicCli
import CliMatcher
import CliParser
import CliToken.Platform
import LazyMount
import ShowCommand

agentConfigDir = None

allAgentCompletion = [ CliParser.Completion( 'WORD', 'Forwarding Agent name', 
                                             literal=False ) ]
AleVerifyCliModel = CliDynamicPlugin( "AleVerifyCliModel" )

def allAgentNames( mode ):
   agents = [ agentName[ 0 ] for agentName in agentConfigDir.items() ]
   return agents

agentNameMatcher = CliMatcher.DynamicKeywordMatcher(
   allAgentNames,
   emptyTokenCompletion=allAgentCompletion )

#--------------------------------------------------------------------------------
# show platform [ AGENT ] pending-state [ quiet ]
#--------------------------------------------------------------------------------

class PlatformPendingStateCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show platform [ AGENT ] pending-state [ quiet ]'
   data = {
      'platform' : CliToken.Platform.platformMatcherForShow,
      'AGENT' : agentNameMatcher,
      'pending-state' : 'Show agent state',
      'quiet' : 'Print only in transient state',
   }
   privileged = True

   handler = "AleVerifyCliHandler.handlePlatformPendingState"

BasicCli.addShowCommandClass( PlatformPendingStateCmd )

#--------------------------------------------------------------------------------
# show platform agent-state verify ( AGENT | all )
#--------------------------------------------------------------------------------

class PlatformAgentStateVerifyAllCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show platform agent-state verify ( AGENT | all )'
   data = {
      'platform' : CliToken.Platform.platformMatcherForShow,
      'agent-state' : 'The agent state',
      'verify' : 'Verify the agent state',
      'all' : 'Verify all agents',
      'AGENT' : agentNameMatcher,
   }
   hidden = True
   privileged = True
   cliModel = "AleVerifyCliModel.VerifyPlatformStateCapiModel"

   handler = "AleVerifyCliHandler.handlePlatformAgentStateVerifyAll"

BasicCli.addShowCommandClass( PlatformAgentStateVerifyAllCmd )

def Plugin( entityManager ):
   global agentConfigDir
   agentConfigDir = LazyMount.mount( entityManager,
                                     'hardware/ale/verifyAgentConfigDir',
                                     'Tac::Dir', 'ri' )
