# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliModel

class VerifyPlatformStateHelper:
   @staticmethod
   def pendingStateCmd( agent, quiet=True ):
      if quiet:
         # pylint: disable-next=consider-using-f-string
         return "show platform %s pending-state quiet" % agent
      else:
         # pylint: disable-next=consider-using-f-string
         return "show platform %s pending-state" % agent

   @staticmethod
   def verifyStateCmd( agent=None, json=False ):
      json = " | json" if json else ""
      if agent:
         # pylint: disable-next=consider-using-f-string
         return "show platform agent-state verify %s" % agent + json
      else:
         return "show platform agent-state verify all" + json

   @staticmethod
   def garbled( agent ):
      # pylint: disable-next=consider-using-f-string
      return "garbled output from agent %s" % agent

   @staticmethod
   def retry():
      return "RETRY VERIFY"

   @staticmethod
   def crash( output ):
      # pylint: disable-next=consider-using-f-string
      return "AGENT CRASHED ?? : all I got is: %s" % output

   @staticmethod
   def end():
      return "END_OF_VERIFICATION"

   @staticmethod
   def getSmDict( jsonDict, agent ):
      # pylint: disable-next=use-dict-literal
      return jsonDict.get( 'agentVerifyState', dict() ).get( agent, dict() ).get(
            'perAgentResult', dict() ) # pylint: disable=use-dict-literal

class PerAgentVerifyResultDict( CliModel.Model ):
   perAgentResult = CliModel.Dict( help='dict of { sm name : error str }',
         keyType=str, valueType=str )

   def setDictFromList( self, pythonList ):
      for errorDict in pythonList:
         for name, err in errorDict.items():
            if name in self.perAgentResult:
               self.perAgentResult[ name ] += "\n" + err.strip()
            else:
               self.perAgentResult[ name ] = err.strip()

class VerifyPlatformStateCapiModel( CliModel.Model ):
   agentVerifyState = CliModel.Dict( help='Agent verify state indexed by agent Name',
         keyType=str, valueType=PerAgentVerifyResultDict )

   def setDict( self, pythonDict ):
      for agent in pythonDict:
         resultDict = PerAgentVerifyResultDict()
         resultDict.setDictFromList( pythonDict[ agent ] )
         self.agentVerifyState[ agent ] = resultDict

   def render( self ):
      for agent in self.agentVerifyState:
         smNameDict = self.agentVerifyState[ agent ].perAgentResult
         if agent not in smNameDict or len( smNameDict ) > 1:
            smNameDict.pop( agent, None )
            print( agent + " : Verify failed/retry" )
            if smNameDict:
               for smName in smNameDict:
                  print( "\t" + smName + ":" )
                  print( "\t\t" + smNameDict[ smName ].replace( "\n", "\n\t\t" ) )
         else:
            print( agent + " : Verify Success" )
