#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import IpAddrMatcher
from CliPlugin.ArBgpCli import sessionTrackerNameMatcher
from CliPlugin.RoutingBgpCli import (
   BgpNEDCmdBaseClass,
   PeerCliExpression,
   RouterBgpSharedModelet,
)
import CliToken.RoutingBgp as bgpTokens

#-------------------------------------------------------------------------------
# "[no|default] neighbor GROUP | ADDR route-reflector cluster-id [cluster-id]"
# command, in "router-bgp" mode.
#-------------------------------------------------------------------------------
class NeighborReflectorClusterIdCmd( BgpNEDCmdBaseClass ):
   syntax = 'neighbor PEER route-reflector cluster-id ( CLUSTER_ID | disabled )'
   noOrDefaultSyntax = 'neighbor PEER route-reflector cluster-id ...'
   data = BgpNEDCmdBaseClass._createSyntaxData( {
      'neighbor' : bgpTokens.neighbor,
      'PEER' : PeerCliExpression,
      'route-reflector' : bgpTokens.routeReflector,
      'cluster-id' : bgpTokens.cluster,
      'CLUSTER_ID' : IpAddrMatcher.ipAddrMatcher,
   } )
   handler = "ArBgpNeighborCliHandler.NeighborReflectorClusterIdCmd_handler"
   noOrDefaultHandler = \
      "ArBgpNeighborCliHandler.NeighborReflectorClusterIdCmd_noOrDefaultHandler"

RouterBgpSharedModelet.addCommandClass( NeighborReflectorClusterIdCmd )

#-------------------------------------------------------------------------------
# "[no|default] neighbor GROUP | ADDR session tracker <name>"
# command, in "router-bgp" mode.
#-------------------------------------------------------------------------------
class NeighborSessionTrackerCmd( BgpNEDCmdBaseClass ):
   syntax = 'neighbor PEER session tracker NAME [ disabled ]'
   noOrDefaultSyntax = 'neighbor PEER session tracker ...'
   data = BgpNEDCmdBaseClass._createSyntaxData( {
      'neighbor' : bgpTokens.neighbor,
      'PEER' : PeerCliExpression,
      'session' : 'Configure BGP session commands',
      'tracker' : 'Configure BGP session tracker',
      'NAME' : sessionTrackerNameMatcher,
   } )
   handler = "ArBgpNeighborCliHandler.NeighborSessionTrackerCmd_handler"
   noOrDefaultHandler = \
      "ArBgpNeighborCliHandler.NeighborSessionTrackerCmd_noOrDefaultHandler"

RouterBgpSharedModelet.addCommandClass( NeighborSessionTrackerCmd )
