# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliCommand import CliCommandClass
import CliDynamicSymbol
from CliPlugin.BridgingEtbaCli import PlatformTfaConfigMode, tfaConfigModeCleanupHook
from Url import UrlMatcher

listUrlLocalSchemes = { "file:", "flash:", "drive:" }
urlLocalMatcher = UrlMatcher(
   lambda fs: fs.scheme in listUrlLocalSchemes,
   "Local URL to load TCAM profile",
   allowAllPaths=True )

class EtbaTrafficPolicyHardwareDefinitionCmd( CliCommandClass ):
   syntax = 'traffic-policy interface hardware definition URL'
   noOrDefaultSyntax = 'traffic-policy interface hardware definition ...'

   data = {
      'traffic-policy': 'Traffic-policy configuration',
      'interface': 'Configuration for traffic policies applied to interfaces',
      'hardware': 'Hardware configuration',
      'definition': 'Hardware capabilities definition',
      'URL': urlLocalMatcher,
   }

   handler = 'ArfaAegisCliHandler.handleHardwareDefinition'
   noOrDefaultHandler = (
      'ArfaAegisCliHandler.handleNoOrDefaultHardwareDefinition' )

PlatformTfaConfigMode.addCommandClass(
      EtbaTrafficPolicyHardwareDefinitionCmd )

def tfaConfigModeCleanup( mode ):
   f = CliDynamicSymbol.resolveSymbol(
      EtbaTrafficPolicyHardwareDefinitionCmd.noOrDefaultHandler )
   f( mode, {} )

tfaConfigModeCleanupHook.addExtension( tfaConfigModeCleanup )
