# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import AgentCommandRequest
import BasicCli
import CliToken.Platform
from CliPlugin.BridgingEtbaCli import tfaNode
from CliPlugin import TechSupportCli
import ShowCommand

platformMatcherForShow = CliToken.Platform.platformMatcherForShow

def showArfaFlowspecConfig( mode, args ):
   AgentCommandRequest.runCliPrintSocketCommand( mode.entityManager,
                                                 "Etba", "debug",
                                                 "SHOW_ARFA_FLOWSPEC",
                                                 mode )

class ShowArfaShowFlowspecConfigCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show platform tfa flowspec config'
   data = {
      'platform' : platformMatcherForShow,
      'tfa' : tfaNode,
      'flowspec' : 'Flowspec for TFA',
      'config' : 'Policy Map Config',
   }

   handler = showArfaFlowspecConfig
   hidden = True

BasicCli.addShowCommandClass( ShowArfaShowFlowspecConfigCmd )

TechSupportCli.registerShowTechSupportCmd(
      '2023-09-21 20:20:20', cmds=[
         "show platform tfa flowspec config",
         ],
      extended="tfa" )
