#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
from CliPlugin.ArfaRoutingSimModel import VrfTriePair
from CliPlugin.BridgingEtbaCli import showArfaAcrJson
from CliPlugin.BridgingEtbaCli import tfaNodeUnguarded
from CliPlugin import VrfCli
import ShowCommand
import CliToken.Platform

platformMatcherForShow = CliToken.Platform.platformMatcherForShow

vrfExprFactory = VrfCli.VrfExprFactory(
   helpdesc='VRF name',
   inclDefaultVrf=True,
   inclAllVrf=True )

def showArfaTrie( mode, args ):
   cmd = "TRIE_IP"

   vrf = args.get( 'VRF' )
   if vrf:
      cmd += " " + vrf

   return showArfaAcrJson( mode, args, VrfTriePair, cmd )

class ShowArfaRoutesCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show platform tfa routes [VRF]'
   data = {
      'platform': platformMatcherForShow,
      'tfa': tfaNodeUnguarded,
      'routes': 'Routes programmed in Arfa',
      'VRF': vrfExprFactory
   }

   hidden = True
   handler = showArfaTrie
   cliModel = VrfTriePair

BasicCli.addShowCommandClass( ShowArfaRoutesCmd )
