# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SharkLazyMount
from CliPlugin.ArpAgentCacheCapacityModels import (
      ArpAgentCacheCapacities,
      Capacity,
      CapacityKinds
)
import Tac

cacheCapacityStatusDir = None

def capacityFromStatus( status, summary ):
   capacity = Capacity( capacity=status.capacity,
                        count = len( status.cacheEntry ) )
   if not summary:
      capacity.cacheEntries = list( status.cacheEntry )

   return capacity

# Example output:
# Entry Kind: dynamic
# Ethernet1
#   Capacity: 5
#   Entries: 3
#     1::1
#     1::2
#     1::3
# Ethernet2
#   Capacity: 5
#   Entries: 3
#     2::2
#     2::5
#     2::8
def showArpAgentCacheCapacity( mode, args ):
   if 'ipv4' in args:
      intfStatus = cacheCapacityStatusDir.arpIntfStatus
   elif 'ipv6' in args:
      intfStatus = cacheCapacityStatusDir.nbrIntfStatus
   else:
      intfStatus = None

   allCacheKinds = { 'dynamic' }
   cacheKinds = set()
   if 'dynamic' in args:
      cacheKinds.add( 'dynamic' )
   if not cacheKinds:
      cacheKinds = allCacheKinds

   intfId = None
   interface = args.get( 'INTF' )
   if interface:
      if not interface.lookup() or not interface.status().deviceName:
         mode.addError( f"{interface.name} not operational" )
         return None
      intfId = Tac.Value( 'Arnet::IntfId', interface.name )

   summary = args.get( 'summary' )

   model = ArpAgentCacheCapacities()

   for cacheKind in cacheKinds:
      capacityKinds = CapacityKinds()
      model.capacityKinds[ cacheKind ] = capacityKinds
      if not intfId:
         # give all the intfs that have a status
         for intfId, status in intfStatus.items():
            capacity = capacityFromStatus( status, summary )
            capacityKinds.interfaces[ intfId ] = capacity
      else:
         if intfId in intfStatus:
            status = intfStatus[ intfId ]
            capacity = capacityFromStatus( status, summary )
            capacityKinds.interfaces[ intfId ] = capacity

   return model

def Plugin( entityManager ):
   global cacheCapacityStatusDir
   autoUnmount = True
   cacheCapacityStatusDir = SharkLazyMount.mount(
      entityManager,
      'arp/cacheCapacity/status',
      'Arp::CacheCapacity::StatusDir',
      SharkLazyMount.mountInfo( 'shadow' ),
      autoUnmount )
