# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-----------------------------------------------------
# Register Arp show commands into "show tech-support".
#-----------------------------------------------------
from CliPlugin import (
   TechSupportCli
)

# Timestamps are made up to maintain historical order within show tech-support
TechSupportCli.registerShowTechSupportCmd(
   '2010-01-01 00:06:10',
   cmds=[
          'show arp vrf all',
          'show ipv6 neighbor vrf all',
          'show arp agent ipv4 input vrf all',
          'show arp agent ipv6 input vrf all',
          'show arp agent ipv4 output vrf all',
          'show arp agent ipv6 output vrf all'
        ] )

#--------------------------------------------------------------------------
# register show tech-support extended evpn
#--------------------------------------------------------------------------
TechSupportCli.registerShowTechSupportCmd(
   '2017-11-03 12:06:12',
   cmds=[ 'show arp vrf all' ],
   extended='evpn' )

TechSupportCli.registerShowTechSupportCmd(
   '2022-06-23 14:58:01',
   cmds=[ 'show ipv6 neighbor vrf all' ],
   extended='evpn' )

TechSupportCli.registerShowTechSupportCmd(
   '2022-06-23 14:58:05',
   cmds=[ 'show arp agent ipv4 input vrf all',
          'show arp agent ipv6 input vrf all',
          'show arp agent ipv4 output vrf all',
          'show arp agent ipv6 output vrf all' ],
   extended='evpn' )
