#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from ArnetModel import IpGenericAddress, MacAddress
from CliModel import DeferredModel, Dict, Bool

class ArpBindingType( DeferredModel ):
   evpnMultihomed = Bool( help='The IP address is EVPN multihomed' )
   vcsRemote = Bool( help='The IP address is received from VCS' )

class ArpBindingVlan( DeferredModel ):
   ipAddresses = Dict( keyType=IpGenericAddress,
                       valueType=MacAddress,
                       help='A mapping of IP address to its MAC address' )
   attributes = Dict( keyType=IpGenericAddress,
                      valueType=ArpBindingType,
                      help='A mapping of IP address to its MAC address attributes' )

class ArpBindingModel( DeferredModel ):
   vlans = Dict( keyType=int,
                 valueType=ArpBindingVlan,
                 help='A mapping of VLAN to its ARP bindings' )
