# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Arnet
from BgpLib import PeerConfigKey

from CliCommand import CliCommandClass, Node
from CliDynamicSymbol import (
   CliDynamicPlugin,
   LazyCallback,
)
from CliMatcher import DynamicKeywordMatcher
from CliPlugin.AgentLibEnableMode import agentKwForEnable, snapshotKw
from CliPlugin.AgentCli import agentNameNewMatcher
from CliPlugin.RoutingBgpShowCli import (
        arBgpShowCmdDict,
        allVrfExprFactory,
)
from CliPlugin.ArBgpCli import vrfExcludeAllExprFactory
from CliPlugin.RoutingBgpShowCliMultiSafi import (
        PeerKeyV4Expression,
        PeerKeyV6Expression,
)
from CliToken.RoutingBgpShowCliTokens import (
        bgpAfterShow,
        routeFlapDamping,
        rfdSuppressed,
        rfdTracked,
        rfdWithdrawn,
        rfdReceived,
        rfdIgnored,
        RouteUnicastAddressFamilyRule,
        neighbors,
        Ipv4OrIpv6AddrMaskLongerMatcher,
)

import BasicCli
import BasicCliModes
import ShowCommand
import Url

BgpCliHelperCliModel = CliDynamicPlugin( "BgpCliHelperCliModel" )

class RegisterShowBgpNlriAfFactoryLazyCallback( LazyCallback ):
   def __init__( self, cmdName, argReplace, argsAdd ):
      self.cmdName = cmdName
      self.argReplace = argReplace
      self.argsAdd = argsAdd
      LazyCallback.__init__( self,
         handlerName="BgpCliHelperCliHandler.getRegisterShowBgpNlriAfCallback" )
      self.__name__ = self.cmdName

   def resolve( self ):
      LazyCallback.resolve( self )
      self.handlerFunc = self.handlerFunc(
         cmdName=self.cmdName, argReplace=self.argReplace, argsAdd=self.argsAdd )

def registerShowBgpNlriAf( cmdName, argReplace=None, argsAdd=None ):
   arBgpShowCmdDict[ cmdName ] = RegisterShowBgpNlriAfFactoryLazyCallback(
      cmdName, argReplace, argsAdd )

def convertPeerAddr( kwargs ):
   key = 'peerAddr'
   peerAddr = kwargs.get( key, None )
   llIntf = ''
   if peerAddr is not None:
      peerKey = PeerConfigKey( peerAddr )
      if peerKey.type == 'peerIpv4':
         peerAddr = peerKey.v4Addr
      elif peerKey.type in [ 'peerIpv6', 'peerIpv6Ll' ]:
         peerAddr = peerKey.v6Addr.stringValue
         llIntf = Arnet.IntfId( peerKey.llIntf ).stringValue
         kwargs[ 'llIntf' ] = llIntf
      kwargs[ key ] = peerAddr

registerShowBgpNlriAf(
        cmdName="doShowIpBgp",
        argsAdd={ "afi": "ipv4" } )

registerShowBgpNlriAf(
        cmdName="doShowIpBgpRoutesDetail",
        argsAdd={ "afi": "ipv4" } )

registerShowBgpNlriAf(
        cmdName="doShowIpBgpRoutesCommunities",
        argsAdd={ "afi": "ipv4" },
        argReplace={ "values": "commValues" } )

registerShowBgpNlriAf(
        cmdName="doShowIpBgpRoutesCommunitiesRegex",
        argReplace={ "regex" : "commRegex" },
        argsAdd={ "afi" : "ipv4" } )

registerShowBgpNlriAf(
        cmdName="doShowIpBgpLargeCommunity",
        argsAdd={ "afi" : "ipv4" },
        argReplace={ "values" : "largeCommValues" } )

registerShowBgpNlriAf(
        cmdName="doShowIpv6Bgp",
        argsAdd={ "afi": "ipv6" } )

registerShowBgpNlriAf(
        cmdName="doShowIpv6BgpRoutesDetail",
        argsAdd={ "afi": "ipv6" } )

registerShowBgpNlriAf(
        cmdName="doShowIpv6BgpRoutesCommunities",
        argsAdd={ "afi": "ipv6" },
        argReplace={ "values": "commValues" } )

registerShowBgpNlriAf(
        cmdName="doShowIpv6BgpLargeCommunity",
        argsAdd={ "afi" : "ipv6" },
        argReplace={ "values" : "largeCommValues" } )

# -------------------------------------------------------------------------------
# show ip[v6] bgp as-path <name> [vrf <vrfName>]
# -------------------------------------------------------------------------------
registerShowBgpNlriAf(
        cmdName="doShowIpBgpRoutesAsPath",
        argsAdd={ "afi" : "ipv4" } )

registerShowBgpNlriAf(
        cmdName="doShowIpv6BgpRoutesAsPath",
        argsAdd={ "afi" : "ipv6" } )


#-------------------------------------------------------------------------------
# show ip[v6] bgp community-list <name> [exact] [detail] [vrf <vrfName>]
#-------------------------------------------------------------------------------
registerShowBgpNlriAf(
        cmdName="doShowIpBgpRoutesCommunityList",
        argsAdd={ "afi" : "ipv4" } )

registerShowBgpNlriAf(
        cmdName="doShowIpv6BgpRoutesCommunityList",
        argsAdd={ "afi" : "ipv6" } )

#-------------------------------------------------------------------------------
# show ip[v6] bgp large-community-list <name> [exact] [detail] [vrf <vrfName>]
#-------------------------------------------------------------------------------
registerShowBgpNlriAf(
        cmdName="doShowIpBgpRoutesLargeCommunityList",
        argsAdd={ "afi" : "ipv4" } )

registerShowBgpNlriAf(
        cmdName="doShowIpv6BgpRoutesLargeCommunityList",
        argsAdd={ "afi" : "ipv6" } )

#-------------------------------------------------------------------------------
# "show ip[v6] bgp regexp <regex> [vrf <vrfName>]
#-------------------------------------------------------------------------------
registerShowBgpNlriAf(
        cmdName="doShowIpBgpRegexp",
        argReplace={ "regex" : "aspRegex" },
        argsAdd={ "afi" : "ipv4" } )

registerShowBgpNlriAf(
        cmdName="doShowIpv6BgpRegexp",
        argReplace={ "regex" : "aspRegex" },
        argsAdd={ "afi" : "ipv6" } )

registerShowBgpNlriAf(
        cmdName="doShowIpBgpAndRegexp",
        argsAdd={ "afi" : "ipv4" } )

#-------------------------------------------------------------------------------
# "show ip(v6) bgp field-set <name> [ detail ] [ vrf <vrfName> ]"
# "show bgp ( ipv4 | ipv6 ) unicast field-set <name> [ detail ] [ vrf <vrfName> ]"
#-------------------------------------------------------------------------------
registerShowBgpNlriAf(
        cmdName="doShowIpBgpFieldSet" )

#-------------------------------------------------------------------------------
# "show (ip | ipv6) bgp neighbors <ip> [(ipv4 unicast) | (ipv6 unicast) |
#       (ipv4 multicast) | (ipv4 labeled-unicast) | (ipv6 labeled-unicast)]
#       (routes | advertised-routes | received-routes [filtered])
#       [<ip> | <prefix>] [longer-prefixes] [detail] [vrf <vrfName>]
#-------------------------------------------------------------------------------

registerShowBgpNlriAf(
      cmdName="doShowIpBgpNeighborsRoutes",
      argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

registerShowBgpNlriAf(
      cmdName="doShowIpv6BgpNeighborsRoutes",
      argsAdd={ "afi" : "ipv6" },
      argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

registerShowBgpNlriAf(
      cmdName="doShowIpBgpNeighborsReceivedRoutes",
      argsAdd={ "routeType": "received-routes" },
      argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

registerShowBgpNlriAf(
      cmdName="doShowIpv6BgpNeighborsReceivedRoutes",
      argsAdd={ "afi" : "ipv6", "routeType" : "received-routes" },
      argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

registerShowBgpNlriAf(
      cmdName="doShowIpBgpNeighborsPrefixAddr",
      argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

registerShowBgpNlriAf(
      cmdName="doShowIpv6BgpNeighborsPrefixAddr",
      argsAdd={ "afi" : "ipv6" },
      argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

registerShowBgpNlriAf(
      cmdName="doShowIpBgpNeighborsPrefixAddrRecvdRts",
      argsAdd={ "routeType": "received-routes" },
      argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

registerShowBgpNlriAf(
      cmdName="doShowIpv6BgpNeighborsPrefixAddrRecvdRts",
      argsAdd={ "afi" : "ipv6", "routeType" : "received-routes" },
      argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

#-------------------------------------------------------------------------------
# "show (ip | ipv6) bgp neighbors <ip>
#       (routes | advertised-routes | received-routes [filtered])
#       community <communities> [exact] [detail] [vrf <vrfName>]
#-------------------------------------------------------------------------------
registerShowBgpNlriAf(
      cmdName="doShowIpBgpNeighborsCommunityRoutes",
      argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

registerShowBgpNlriAf(
      cmdName="doShowIpv6BgpNeighborsCommunityRoutes",
      argsAdd={ "afi" : "ipv6" },
      argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

registerShowBgpNlriAf(
      cmdName="doShowIpBgpNeighborsCommunityRecvdRoutes",
      argsAdd={ "routeType": "received-routes" },
      argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

registerShowBgpNlriAf(
      cmdName="doShowIpv6BgpNeighborsCommunityRecvdRoutes",
      argsAdd={ "afi" : "ipv6", "routeType" : "received-routes" },
      argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

# -------------------------------------------------------------------------------
# "show (ip | ipv6) bgp neighbors <ip>
#       (routes | advertised-routes | received-routes [filtered])
#       as-path access-list <name> [vrf <vrfName>]
# -------------------------------------------------------------------------------
registerShowBgpNlriAf(
      cmdName="doShowIpBgpNeighborsAsPathListRoutes",
      argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

registerShowBgpNlriAf(
      cmdName="doShowIpv6BgpNeighborsAsPathListRoutes",
      argsAdd={ "afi" : "ipv6" },
      argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

registerShowBgpNlriAf(
      cmdName="doShowIpBgpNeighborsAsPathListRecvdRoutes",
      argsAdd={ "routeType" : "received-routes" },
      argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

registerShowBgpNlriAf(
      cmdName="doShowIpv6BgpNeighborsAsPathListRecvdRoutes",
      argsAdd={ "afi" : "ipv6", "routeType" : "received-routes" },
      argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

#-------------------------------------------------------------------------------
# "show ip bgp neighbors <ip> { received-routes [ filtered ] | routes |
# advertised-routes } regexp <regex> [vrf <vrfName>]"
#-------------------------------------------------------------------------------

registerShowBgpNlriAf(
   cmdName="doShowIpBgpNbrRtsRegex",
   argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

registerShowBgpNlriAf(
   cmdName="doShowIpBgpNbrRecvdRtsRegex",
   argsAdd={ "routeType" : "received-routes" },
   argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

#-------------------------------------------------------------------------------
# Deprecated command:
# "show ipv6 bgp neighbors <ip> { received-routes [ filtered ] | routes |
# advertised-routes } regexp <regex> [vrf <vrfName>]"
#
# New version:
# "show ipv6 bgp peers <ip> { received-routes [ filtered ] | routes |
# advertised-routes } regexp <regex> [vrf <vrfName>]"
#-------------------------------------------------------------------------------

registerShowBgpNlriAf(
   cmdName="doShowIpv6BgpNbrRtsRegex",
   argsAdd={ "afi" : "ipv6" },
   argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

registerShowBgpNlriAf(
   cmdName="doShowIpv6BgpNbrRecvdRtsRegex",
   argsAdd={ "afi" : "ipv6", "routeType" : "received-routes" },
   argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

#-------------------------------------------------------------------------------
# "show bgp ( ipv4 | ipv6 ) unicast [ <ip> | <prefix> [longer-prefixes] ]
#       [ ( community [<communities>] [exact] ) | (as-path access-list <name>) ]
#       [ detail ] [ vrf < vrfName > ]
#
# "show bgp ipv4 multicast [ <ip> | <prefix> [longer-prefixes] ]
#       [ ( community [<communities>] [exact] ) | (as-path access-list <name>) ]
#       [ detail ] [ vrf < vrfName > ]
#-------------------------------------------------------------------------------
registerShowBgpNlriAf(
       cmdName="doShowBgpNlriAf",
       argReplace=LazyCallback(
         "BgpCliHelperCliHandler.flattenShowBgpNlriAf" ) )

#-------------------------------------------------------------------------------
# "show bgp neighbors <ip> [(ipv4 unicast) | (ipv6 unicast) | (ipv4 multicast) |
#       (ipv4 labeled-unicast) | (ipv6 labeled-unicast)]
#       ( routes | advertised-routes | received-routes [filtered] )
#       [ <ip> | <prefix> [longer-prefixes] ]
#       [ community [<communities>] [exact] ] [detail] [vrf <vrfName>]
#-------------------------------------------------------------------------------
registerShowBgpNlriAf(
       cmdName="doShowBgpNeighborsNlriAfRoutes",
       argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )
registerShowBgpNlriAf(
       cmdName="doShowBgpNeighborsNlriAfPrefixAddr",
       argReplace=LazyCallback(
         "BgpCliHelperCliHandler.handleShowIpBgpNeighborsRoutesArgs" ) )

class ShowBgpSegmentRoutingCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show bgp segment-routing prefix-segments'
   data = {
      'bgp' : 'BGP information',
      'segment-routing' : 'Segment Routing Information',
      'prefix-segments' : 'Prefix Segment Information',
   }

   cliModel = "BgpCliHelperCliModel.PrefixSegments"
   handler = "BgpCliHelperCliHandler.ShowBgpSegmentRoutingCmd_handler"

BasicCli.addShowCommandClass( ShowBgpSegmentRoutingCmd )

def bgpAgent( mode, context ):
   agent = context.sharedResult[ 'AGENT' ]
   if agent == "Bgp":
      return { 'mrt' : "Multi-threaded RIB toolkit format" }
   return {}

# ----------------------------------------------------
# agent Bgp snapshot mrt received routes [ VRF ] FILE
# ----------------------------------------------------
# We already have a "agent AGENT snapshot core..." command
# So do not add "Bgp" as a token like "agent Bgp snapshot mrt..."
# as it will show up both AGENT and Bgp in the completions. Instead
# generate this mrt command only if the AGENT passed is Bgp by generating
# the 'mrt' keyword dynamically only if the AGENT passed is Bgp
class AgentBgpSnapshotMrtCmd( CliCommandClass ):
   syntax = "agent AGENT snapshot MRT received routes [ VRF ] FILE"
   data = {
      "agent" : agentKwForEnable,
      "AGENT" : Node( agentNameNewMatcher,
                      storeSharedResult=True ),
      "snapshot" : snapshotKw,
      "MRT" : DynamicKeywordMatcher( bgpAgent, passContext=True ),
      "received" : "Received routes dump",
      "routes" : "Routes dump",
      "VRF" : vrfExcludeAllExprFactory,
      "FILE" : Url.UrlMatcher( lambda fs : ( fs.fsType == 'flash' and
                                             fs.supportsWrite() ),
                               "Send output to a file" ),
   }

   handler = "BgpCliHelperCliHandler.AgentBgpSnapshotMrtCmd_handler"

BasicCliModes.EnableMode.addCommandClass( AgentBgpSnapshotMrtCmd )

class ShowBgpRfdCmd( ShowCommand.ShowCliCommandClass ):
   syntax = """show bgp route-flap-damping UNICAST_AFI_SAFI
         [ neighbors ( IP_PEER | IP6_PEER ) ]
         [ IPV4_OR_IPV6_ADDR_MASK_LONGER ]
         [ ( received | withdrawn ) ]
         [ ( suppressed | tracked | ignored ) ]
         [ VRF ]
         """
   data = {
         "bgp" : bgpAfterShow,
         "route-flap-damping" : routeFlapDamping,
         "UNICAST_AFI_SAFI" : RouteUnicastAddressFamilyRule,
         "neighbors" : neighbors,
         "IP_PEER" : PeerKeyV4Expression,
         "IP6_PEER" : PeerKeyV6Expression,
         "IPV4_OR_IPV6_ADDR_MASK_LONGER" : Ipv4OrIpv6AddrMaskLongerMatcher,
         "suppressed" : rfdSuppressed,
         "tracked" : rfdTracked,
         "ignored" : rfdIgnored,
         "received" : rfdReceived,
         "withdrawn" : rfdWithdrawn,
         "VRF" : allVrfExprFactory,
         }

   cliModel = "BgpCliHelperCliModel.rfdRouteVrfModel"
   handler = "BgpCliHelperCliHandler.showBgpRfdCmdHandler"

BasicCli.addShowCommandClass( ShowBgpRfdCmd )

def Plugin( entityManager ):
   return
