#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliMatcher
from CliPlugin.RoutingBgpCli import V4V6PeerKeyCliExpression
from CliPlugin.RoutingBgpShowCli import summaryVrfModel
from CliToken.RoutingBgpShowCliTokens import (
   bgpAfterShow,
   detail,
   neighbors,
   routeTypeMatcher,
   summary,
)
from ShowCommand import ShowCliCommandClass

pathSelectionAfterShowBgp = CliMatcher.KeywordMatcher(
   "path-selection",
   helpdesc="Path selection information" )

# -------------------------------------------------------------------------------
# show bgp path-selection summary
# -------------------------------------------------------------------------------

class ShowBgpPathSelectionSummary( ShowCliCommandClass ):
   syntax = 'show bgp path-selection summary'
   data = {
         "bgp": bgpAfterShow,
         "path-selection": pathSelectionAfterShowBgp,
         "summary": summary,
   }
   cliModel = summaryVrfModel
   handler = "BgpDpsShowCliHandler.handlerShowBgpPathSelectionSummary"

BasicCli.addShowCommandClass( ShowBgpPathSelectionSummary )

# -------------------------------------------------------------------------------
# show bgp path-selection [ detail ]
# -------------------------------------------------------------------------------
class ShowBgpPathSelection( ShowCliCommandClass ):
   syntax = 'show bgp path-selection [ detail ]'
   data = {
      "bgp": bgpAfterShow,
      "path-selection": pathSelectionAfterShowBgp,
      "detail": detail,
   }
   cliModel = "BgpDpsCliModels.BgpDpsRoutesVrfModel"
   handler = "BgpDpsShowCliHandler.handlerShowBgpPathSelection"

BasicCli.addShowCommandClass( ShowBgpPathSelection )

# -------------------------------------------------------------------------------
# show bgp neighbors <neighbor_addr> path-selection
#   ( advertised - routes | received - routes | routes ) [ detail ]
# -------------------------------------------------------------------------------
class ShowBgpNeighborPathSelection( ShowCliCommandClass ):
   syntax = "show bgp neighbors PEER_ADDR path-selection ROUTE_TYPE [ detail ]"
   data = {
      "bgp": bgpAfterShow,
      "neighbors": neighbors,
      "PEER_ADDR": V4V6PeerKeyCliExpression,
      "path-selection": pathSelectionAfterShowBgp,
      "ROUTE_TYPE": routeTypeMatcher,
      "detail": detail,
   }
   cliModel = "BgpDpsCliModels.BgpDpsRoutesVrfModel"
   handler = "BgpDpsShowCliHandler.handlerShowBgpNeighborPathSelection"

BasicCli.addShowCommandClass( ShowBgpNeighborPathSelection )
