# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import IpGenAddrMatcher
from CliPlugin.MplsCli import (
   mplsNodeForShow,
   bindingsKw,
)
from CliPlugin.MplsModel import MplsBindingsModel
from CliPlugin.TechSupportCli import (
   techSupportKwMatcher,
   extendedKwMatcher,
   ShowTechModel,
)
from CliPlugin.BgpCliModels import BgpSummary
from CliPlugin.RoutingBgpCli import V4V6PeerKeyCliExpression
from CliToken.RoutingBgpShowCliTokens import (
   bgpAfterShow,
   detail,
   summary,
   summaryGeneric,
   neighbors,
   RouteTypeMaybeFilteredMatcher,
   CommunityValuesAndExactRule,
)
from CliToken.BgpLs import (
   BgpLsNlriType,
   tokenLinkState,
)
import BasicCli
from CliMatcher import KeywordMatcher
from ShowCommand import ShowCliCommandClass
from Toggles import RoutingLibToggleLib

bgpKwMatch = KeywordMatcher( 'bgp',
      helpdesc='Show tech-support extended bgp command' )
#----------------------------------------------------------
# 'show bgp link-state summary'
#----------------------------------------------------------
class ShowBgpLsSummary( ShowCliCommandClass ):
   syntax = "show bgp link-state summary"
   data = {
         "bgp": bgpAfterShow,
         "link-state": tokenLinkState,
         "summary": summary,
         }
   cliModel = BgpSummary
   handler = "BgpLsCliHandler.handlerShowBgpLsSummary"

BasicCli.addShowCommandClass( ShowBgpLsSummary )
#---------------------------------------------------------
# 'show bgp link-state [ node | link | ipv4-prefix | ipv6-prefix ] [ detail ]'
#---------------------------------------------------------
class ShowBgpLsNlri( ShowCliCommandClass ):
   syntax = "show bgp link-state [ NLRI_TYPE ] [ detail ]"
   data = {
         "bgp": bgpAfterShow,
         "link-state": tokenLinkState,
         "NLRI_TYPE": BgpLsNlriType,
         "detail": detail,
         }
   cliModel = "BgpLsCliModels.BgpLsRoutesVrfModel"
   handler = "BgpLsCliHandler.handlerShowBgpLsNlri"

#----------------------------------------------------------------
# 'show bgp neighbors <neigh_addr> link-state
#       (advertised-routes | (received-routes [ filtered ]) | routes)
#       [ community ] [ nlriType ] [ detail ]'
#----------------------------------------------------------------
class ShowBgpLsRoutes( ShowCliCommandClass ):
   syntax = "show bgp neighbors PEER_ADDR link-state routeType"\
            "[ community ] [ NLRI_TYPE ] [ detail ]"
   data = {
         "bgp": bgpAfterShow,
         "neighbors": neighbors,
         "PEER_ADDR": V4V6PeerKeyCliExpression,
         "link-state": tokenLinkState,
         "routeType": RouteTypeMaybeFilteredMatcher,
         "community": CommunityValuesAndExactRule,
         "NLRI_TYPE": BgpLsNlriType,
         "detail": detail,
      }
   cliModel = "BgpLsCliModels.BgpLsRoutesVrfModel"
   handler = "BgpLsCliHandler.handlerShowBgpLsRoutes"

#-----------------------------------------------------------------------------------
# show tech-support extended bgp link-state
#-----------------------------------------------------------------------------------
# Creating a seperate show command class for this since there are 2 keyword
# tokens following extended keyword and the existing 'ShowTechSupport'
# cannot accommodate that syntax
class ShowTechExtBgpLsSupport( ShowCliCommandClass ):
   syntax = ( 'show tech-support extended bgp link-state' )
   data = {
            'tech-support': techSupportKwMatcher,
            'extended': extendedKwMatcher,
            'bgp': bgpKwMatch,
            'link-state': tokenLinkState,
          }
   privileged = True
   cliModel = ShowTechModel
   handler = "BgpLsCliHandler.handlerShowTechExtBgpLsSupport"

# --------------------------------------------------------------------------------
# show mpls bgp link-state bindings [ PREFIX ] [ detail | summary ]
# --------------------------------------------------------------------------------
class ShowMplsBgpLsBindingsCmd( ShowCliCommandClass ):
   syntax = 'show mpls bgp link-state bindings [ PREFIX ] [ detail | summary ]'
   data = {
      'mpls': mplsNodeForShow,
      'bgp': bgpAfterShow,
      'link-state': tokenLinkState,
      'bindings': bindingsKw,
      'PREFIX': IpGenAddrMatcher.IpGenPrefixMatcher(
         helpdesc='Prefix to match',
         helpdesc4='IPv4 prefix to match',
         helpdesc6='IPv6 prefix to match' ),
      'detail': detail,
      'summary': summaryGeneric,
   }
   cliModel = MplsBindingsModel
   handler = "BgpLsCliHandler.showMplsBgpLsBindingsCmdHandler"

BasicCli.addShowCommandClass( ShowBgpLsNlri )
BasicCli.addShowCommandClass( ShowBgpLsRoutes )
BasicCli.addShowCommandClass( ShowTechExtBgpLsSupport )
if RoutingLibToggleLib.toggleBgpLsProducerBgpEpeEnabled():
   BasicCli.addShowCommandClass( ShowMplsBgpLsBindingsCmd )
