#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from BasicCli import addShowCommandClass
from CliDynamicSymbol import LazyCallback
import CliMatcher
# pylint:disable=W0611
import CliPlugin.BgpCliHelperCli
from CliPlugin.IpAddrMatcher import ipAddrMatcher
from CliPlugin.RoutingBgpShowCli import routeSummaryVrfModel
from CliPlugin.RoutingBgpShowCli import (
   arBgpShowCmdDict,
   allVrfExprFactory
)
from CliToken.RoutingBgpShowCliTokens import (
   bgpAfterShow,
   detail,
   endpoint,
   ipGenAddrMatcher,
   srTeAfterShowBgp
   )
from CliToken.AvtCliToken import (
   AvtNameExprFactory,
   vrfNameMatcher,
)
from ShowCommand import ShowCliCommandClass

avtFilterHelpStr = 'Filter by adaptive virtual topology name'

arBgpShowCmdDict[ 'doShowBgpSrTeSummary' ] = \
   LazyCallback( "BgpSrTePolicyShowCliHandler.doShowBgpSrTeSummary" )
arBgpShowCmdDict[ 'doShowBgpSrTeRoutes' ] = \
   LazyCallback( "BgpSrTePolicyShowCliHandler.doShowBgpSrTeRoutes" )
arBgpShowCmdDict[ 'doShowBgpSrTeRoutesCommunities' ] = \
   LazyCallback( "BgpSrTePolicyShowCliHandler.doShowBgpSrTeRoutesCommunities" )
arBgpShowCmdDict[ 'doShowBgpSrTeRoutesCommunityList' ] = \
   LazyCallback( "BgpSrTePolicyShowCliHandler.doShowBgpSrTeRoutesCommunityList" )
arBgpShowCmdDict[ 'doShowBgpSrTeNeighborRoutes' ] = \
   LazyCallback( "BgpSrTePolicyShowCliHandler.doShowBgpSrTeNeighborRoutes" )

# ---------------------------------------------------------------------------------
# "show bgp sr-te endpoint <> path-selection color-vrf <colorVrfName> avt <avtName>
#    router <IPv4 address> [ detail ] [ vrf <vrfName> ]"
# ---------------------------------------------------------------------------------
pathSelectionMatcher = CliMatcher.KeywordMatcher(
   'path-selection',
   helpdesc='Dynamic path selection policy' )
colorVrfMatcher = CliMatcher.KeywordMatcher(
   'color-vrf',
   helpdesc='VRF of the dynamic path selection policy' )
routerMatcher = CliMatcher.KeywordMatcher( 'router', helpdesc='Source router ID' )

class ShowBgpSrTeDpsPolicyEndpoint( ShowCliCommandClass ):
   syntax = """show bgp sr-te
               endpoint ENDPOINT_VALUE
               path-selection
               color-vrf COLOR_VRF
               AVT
               router ROUTER_ID
               [ detail ] [ VRF ]
            """
   data = {
         "bgp": bgpAfterShow,
         "sr-te": srTeAfterShowBgp,
         "endpoint": endpoint,
         "ENDPOINT_VALUE": ipGenAddrMatcher,
         "path-selection": pathSelectionMatcher,
         "color-vrf": colorVrfMatcher,
         "COLOR_VRF": vrfNameMatcher,
         "AVT": AvtNameExprFactory( avtFilterHelpStr ),
         "router": routerMatcher,
         "ROUTER_ID": ipAddrMatcher,
         "detail": detail,
         "VRF": allVrfExprFactory,
      }
   cliModel = routeSummaryVrfModel
   handler = "BgpSrTePolicyShowCliHandler.handlerShowBgpSrTeDpsPolicyEndpoint"

addShowCommandClass( ShowBgpSrTeDpsPolicyEndpoint )
