# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import ConfigMount
import CliMatcher
import CliCommand
import CliParser
from CliPlugin.Ip6AddrMatcher import ip6PrefixMatcher
from CliPlugin.IpAddrMatcher import ipPrefixMatcher
from CliPlugin.RoutingBgpCli import RouterBgpBaseMode, RouterBgpVrfMode, \
      deleteRouterBgpVrfHook
from CliPlugin.RoutingBgpCli import bgpMatcherForConfig, ipv4PeerMatcher, \
      ipv6PeerMatcher
import Tac

entityManager = None
vrfTraceFacilityDir = None

def deleteBgpVrfTraceHook( vrfName ):
   if vrfName in vrfTraceFacilityDir.traceFacility:
      del vrfTraceFacilityDir.traceFacility[ vrfName ]

def traceFacilityForVrf( vrfName ):
   return vrfTraceFacilityDir.traceFacility[ vrfName ]

class RouterBgpTraceSharedModelet( CliParser.Modelet ):
   def __init__( self, mode ):
      CliParser.Modelet.__init__( self, mode )
      vrfTraceFacilityDir.traceFacility.newMember( mode.vrfName )

RouterBgpBaseMode.addModelet( RouterBgpTraceSharedModelet )
RouterBgpVrfMode.addModelet( RouterBgpTraceSharedModelet )

traceHiddenMatcher = CliCommand.Node(
      matcher=CliMatcher.KeywordMatcher( 'trace',
         helpdesc="Configure BGP trace settings" ), hidden=True )

#-------------------------------------------------------------------------------
# [ no | default ] bgp trace neighbor ( <ip> | all )
#-------------------------------------------------------------------------------
class BgpTraceNeighbor( CliCommand.CliCommandClass ):
   syntax = "bgp trace neighbor ( ADDR | ADDR6 | all )"
   noOrDefaultSyntax = syntax
   data = {
         'bgp' : bgpMatcherForConfig,
         'trace' : traceHiddenMatcher,
         'ADDR' : ipv4PeerMatcher,
         'ADDR6' : ipv6PeerMatcher,
         'neighbor' : 'Neighbor trace settings',
         'all' : 'All trace facilities'
         }

   @staticmethod
   def adapter( mode, args, argsList ):
      if 'ADDR' in args:
         args[ 'PEER' ] = args[ 'ADDR' ]
      elif 'ADDR6' in args:
         args[ 'PEER' ] = args[ 'ADDR6' ]

   handler = "BgpTraceCliHandler.BgpTraceNeighbor_handler"
   noHandler = "BgpTraceCliHandler.BgpTraceNeighbor_noHandler"
   defaultHandler = "BgpTraceCliHandler.BgpTraceNeighbor_defaultHandler"

RouterBgpTraceSharedModelet.addCommandClass( BgpTraceNeighbor )

#-------------------------------------------------------------------------------
# [ no | default ] bgp trace route-key ( <prefix> | <afi> [<safi>] | all )
#-------------------------------------------------------------------------------

class BgpTraceRouteKey( CliCommand.CliCommandClass ):
   syntax = (
         "bgp trace route-key ( PREFIX | PREFIX6 | ( ipv4 | ipv6 unicast ) | all )" )
   noOrDefaultSyntax = syntax
   data = {
         'bgp' : bgpMatcherForConfig,
         'trace' : traceHiddenMatcher,
         'route-key' : 'Route-key trace settings',
         'neighbor' : 'Neighbor trace settings',
         'PREFIX' : ipPrefixMatcher,
         'PREFIX6' : ip6PrefixMatcher,
         'ipv4' : 'IPv4 related',
         'ipv6' : 'IPv6 related',
         'unicast' : 'Unicast sub-address family',
         'all' : 'All trace facilities'
         }

   @staticmethod
   def adapter( mode, args, argsList ):
      if 'PREFIX' in args:
         args[ 'PEER' ] = args[ 'PREFIX' ]
      elif 'PREFIX6' in args:
         args[ 'PEER' ] = args[ 'PREFIX6' ]
      if 'ipv4' in args:
         args[ 'AFI' ] = 'afiIpv4'
      elif 'ipv6' in args:
         args[ 'AFI' ] = 'afiIpv6'

   handler = "BgpTraceCliHandler.BgpTraceRouteKey_handler"
   noHandler = "BgpTraceCliHandler.BgpTraceRouteKey_noHandler"
   defaultHandler = "BgpTraceCliHandler.BgpTraceRouteKey_defaultHandler"

RouterBgpTraceSharedModelet.addCommandClass( BgpTraceRouteKey )


def Plugin( em ):
   global entityManager
   global vrfTraceFacilityDir
   entityManager = em
   vrfTraceFacilityDir = ConfigMount.mount(
         entityManager, 'routing/arbgp/trace',
         'Routing::Bgp::VrfTraceFacilityDir', 'w' )

   deleteRouterBgpVrfHook.addExtension( deleteBgpVrfTraceHook )
