#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliPlugin.TechSupportCli
import LazyMount
from IpLibTypes import ProtocolAgentModelType

l3Config = None
bgpConfig = None

# ---------------------------------------------------------------------------
# Add BGP VPLS related commands to 'show tech-support'.
# These commands only apply to multi-agent mode, in ribd mode we will not run
# them.
# ---------------------------------------------------------------------------
def _showTechBgpVplsGuard():
   return bgpConfig.asNumber != 0 and \
      l3Config.protocolAgentModel == ProtocolAgentModelType.multiAgent

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2022-01-01 12:00:00',
   cmds=[ 'show bgp vpls summary',
          'show bgp vpls detail',
          'show bgp vpls auto-discovery' ],
   cmdsGuard=_showTechBgpVplsGuard,
   summaryCmds=[ 'show bgp vpls summary',
                 'show bgp vpls detail',
                 'show bgp vpls auto-discovery' ],
   summaryCmdsGuard=_showTechBgpVplsGuard )

def Plugin( entityManager ):
   global l3Config
   global bgpConfig

   l3Config = LazyMount.mount( entityManager, 'l3/config',
                               'L3::Config', 'r' )

   bgpConfig = LazyMount.mount( entityManager, 'routing/bgp/config',
                                'Routing::Bgp::Config', 'r' )
