# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
from CliCommand import CliExpression
import CliMatcher
from CliPlugin.IpAddrMatcher import ipPrefixMatcher
from CliPlugin.Ip6AddrMatcher import ip6PrefixMatcher
from CliPlugin.IraVrfCli import routeDistinguisherMatcher
from CliPlugin.RouteMapCli import (
        RtSooExtCommCliMatcher,
        LargeCommCliMatcher,
        showLargeCommunityDesc,
)
import CliToken.RoutingBgp as bgpTokens
from CliToken.RoutingBgpShowCliTokens import (
      communityExact,
      longerPrefixes,
      ipGenAddrMatcher,
      showLargeCommunity,
      )
#------------------------------------------------------------------------------
# This file contains common CLI tokens used by MplsVpn and Evpn CliPlugins
#------------------------------------------------------------------------------
# NOTE: This file contains old CLI Parser token as well which are used by Evpn
# CliPlugins. We should remove them once Evpn CliPlugin is also converted for
# new CLI Parser.
showExtCommunity = CliMatcher.KeywordMatcher( "extcommunity",
      helpdesc="Filter by BGP/VPN extended community list" )

# extcommunity filter
class ExtCommValuesAndExactExpression( CliExpression ):
   expression = "extcommunity { rt RT_VAL } [ EXT_COMM_EXACT ]"
   data = {
         "extcommunity" : showExtCommunity,
         "rt" : "Route Target",
         "RT_VAL" : RtSooExtCommCliMatcher( "Route Target" ),
         "EXT_COMM_EXACT" : communityExact,
      }

   @staticmethod
   def adapter( mode, args, argList ):
      if not args.pop( "extcommunity", None ):
         return
      result = { "extCommunityValues" : args.pop( "RT_VAL" ) }
      if args.pop( "EXT_COMM_EXACT", None ):
         result[ "exact" ] = "exact"
      args[ "EXT_COMMUNITIES" ] = result

# large-community filter
class LargeCommValuesAndExactExpression( CliExpression ):
   expression = "large-community { LARGE_COMM_VAL } [ LARGE_COMM_EXACT ]"
   data = {
         "large-community" : showLargeCommunity,
         "LARGE_COMM_VAL" : LargeCommCliMatcher( showLargeCommunityDesc ),
         "LARGE_COMM_EXACT" : communityExact,
      }

   @staticmethod
   def adapter( mode, args, argList ):
      if not args.pop( "large-community", None ):
         return
      result = { "largeCommListVal" : args.get( "LARGE_COMM_VAL" ),
                 "exact" : args.get( "LARGE_COMM_EXACT" ) }
      args[ "LARGE_COMMUNITIES" ] = result

# rd filter
class RdCliExpression( CliExpression ):
   expression = "rd ( RD_VAL )"
   data = { "rd" : "Filter by route distinguisher",
            "RD_VAL" : routeDistinguisherMatcher
         }

# ipv4 prefix filter
class IpPrefixShowExpression ( CliExpression ):
   expression = "( PREFIX [ longer-prefixes ] )"
   data = { "PREFIX" : ipPrefixMatcher,
            "longer-prefixes" : longerPrefixes
          }

# ipv6 prefix filter
class Ipv6PrefixShowExpression ( CliExpression ):
   expression = "( PREFIX [ longer-prefixes ] )"
   data = { "PREFIX" : ip6PrefixMatcher,
            "longer-prefixes" : longerPrefixes
          }

# nexthop filter
class NexthopExpression( CliExpression ):
   expression = "next-hop nexthop-addr"
   data = { "next-hop" : 'Filter by next hop ( IPv4 or IPv6 ) address',
            "nexthop-addr" : ipGenAddrMatcher
          }

# route import export keywords
tokenRoute = CliMatcher.KeywordMatcher(
   'route', helpdesc='Route configuration' )
tokenVpnImport = CliMatcher.KeywordMatcher(
   'import', helpdesc='Configure the importing of VPN routes' )
tokenVpnExport = CliMatcher.KeywordMatcher(
   'export', helpdesc='Configure the exporting of VPN routes' )

#---------------------------------------------------------------------------------
# "[no|default] route import match-failure action discard"
# in the following modes:
#     address-family vpn-ipv4
#     address-family vpn-ipv6
#     address-family evpn
#
# Enables the discarding of VPN paths that won't be imported into any VRF (AID6625).
#---------------------------------------------------------------------------------
class RouteImportMatchFailureDiscardCmd( CliCommand.CliCommandClass ):
   syntax = 'route import match-failure action discard'
   noOrDefaultSyntax = 'route import match-failure action ...'
   data = { 'route' : tokenRoute,
            'import' : tokenVpnImport,
            'match-failure' : 'Configure how to handle VPN routes with no matching '
                              'VRF import Route Targets',
            'action' : 'Configure the action to perform',
            'discard' : 'Discard the route' }
   handler = "BgpVpnCliHandler.handlerRouteImportMatchFailureDiscardCmd"
   noOrDefaultHandler = \
      "BgpVpnCliHandler.noOrDefaultHandlerRouteImportMatchFailureDiscardCmd"

# ---------------------------------------------------------------------------------
# "[no | default] vpn client ibgp attribute tunneling"
# in the following modes:
#     address-family vpn-ipv4
#     address-family vpn-ipv6
#     address-family evpn
#
# Enables or disables RFC 6368 behavior when importing/exporting routes.
# RFC 6368 refers to MPLS only, this was extended further to EVPN.
# ---------------------------------------------------------------------------------
class VpnClientIbgpAttributeTunneling( CliCommand.CliCommandClass ):
   syntax = 'vpn client ibgp attribute tunneling'
   noOrDefaultSyntax = syntax

   data = {
      'vpn' : bgpTokens.vpnForAfContext,
      'client' : bgpTokens.vpnClient,
      'ibgp' : bgpTokens.vpnClientIbgp,
      'attribute' : bgpTokens.attribute,
      'tunneling' : bgpTokens.attributeTunneling
   }
   handler = "BgpVpnCliHandler.handlerVpnClientIbgpAttributeTunneling"
   noOrDefaultHandler = \
      "BgpVpnCliHandler.noOrDefaultHandlerVpnClientIbgpAttributeTunneling"
