#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=ungrouped-imports

import BasicCli
import CliCommand
import CliMatcher
import ShowCommand
import CliPlugin.BlackBox as BlackBox # pylint: disable=consider-using-from-import

matcherConsole = CliMatcher.KeywordMatcher( 'console',
                                            helpdesc='Persistent console' )
matcherReload = CliMatcher.KeywordMatcher( 'reload',
                                           helpdesc='Display system reload status' )

#--------------------------------------------------------------------------------
# show reload console logs [ FILENUM ]
#--------------------------------------------------------------------------------
class ReloadConsoleLogsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show reload console logs [ FILENUM ]'
   data = {
      'reload': matcherReload,
      'console': matcherConsole,
      'logs': CliCommand.Node( matcher=CliMatcher.KeywordMatcher(
                                 'logs', helpdesc='Show persistent console logs' ),
                               guard=BlackBox.blackboxGuard ),
      'FILENUM': CliMatcher.IntegerMatcher( 0, 9,
                                            helpdesc='Console log file number' ),
   }
   handler = BlackBox.doShowPersistentLogs
   cliModel = BlackBox.ConsoleOutput
   privileged = True

BasicCli.addShowCommandClass( ReloadConsoleLogsCmd )

#--------------------------------------------------------------------------------
# show reload console status
#--------------------------------------------------------------------------------
class ReloadConsoleStatusCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show reload console status'
   data = {
      'reload': matcherReload,
      'console': matcherConsole,
      'status': 'Show persistent logging status',
   }
   handler = BlackBox.doShowReloadConsoleStatus
   cliModel = BlackBox.BlackboxStatusDetail
   privileged = True

BasicCli.addShowCommandClass( ReloadConsoleStatusCmd )
