#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

import BasicCli
import BasicCliModes
import CliCommand
import CliGlobal
import CliMatcher
import CliParser
from CliPlugin.CableTestCliModel import InterfaceBaseTCableTestStatuses
from CliPlugin import EthIntfCli
from CliPlugin import IntfCli
from CliToken.Test import testMatcherForExec
import Intf
import LazyMount
import ShowCommand

gv = CliGlobal.CliGlobal( dict( cableTestSliceDir=None ) )

def cableTestGuard( mode, token ):
   for linecard in gv.cableTestSliceDir.values():
      for subSlice in linecard.values():
         if subSlice.cableTestStatus:
            return None
   return CliParser.guardNotThisPlatform

#--------------------------------------------------------------------------------
# Declare Tokens
#--------------------------------------------------------------------------------
l1Matcher = CliMatcher.KeywordMatcher( 'l1',
                                       helpdesc='Layer 1 features' )
cableTestNode = CliCommand.guardedKeyword( 'cable',
                                           helpdesc='Test layer 1 cable',
                                           guard=cableTestGuard )
baseTMatcher = CliMatcher.KeywordMatcher( 'base-t',
                                          helpdesc='Base-T interfaces' )
intfMatcher = CliMatcher.KeywordMatcher( 'interfaces',
                                         helpdesc='Ethernet interfaces' )
cableShowNode = CliCommand.guardedKeyword( 'cable',
                                           helpdesc='Display cable test result',
                                           guard=cableTestGuard )
intfRangeMatcher = Intf.IntfRange.IntfRangeMatcher(
   explicitIntfTypes=( EthIntfCli.EthPhyAutoIntfType, ) )

#--------------------------------------------------------------------------------
# "test l1 cable base-t interfaces INTFS" command in enable mode
#--------------------------------------------------------------------------------
class BaseTCableTest( CliCommand.CliCommandClass ):
   syntax = 'test l1 cable base-t interfaces INTFS'
   data = {
      'test': testMatcherForExec,
      'l1' : l1Matcher,
      'cable' : cableTestNode,
      'base-t' : baseTMatcher,
      'interfaces' : intfMatcher,
      'INTFS': intfRangeMatcher,
      }

   handler = "CableTestCliHandler.baseTCableTestHandler"

BasicCliModes.EnableMode.addCommandClass( BaseTCableTest )

#--------------------------------------------------------------------------------
# show interfaces [ INTFS ] cable detail
#--------------------------------------------------------------------------------
class ShowIntfCableDetail( ShowCommand.ShowCliCommandClass ):
   syntax = "show interfaces [ INTFS ] cable detail"
   data = {
      'interfaces' : IntfCli.interfacesShowKw,
      'INTFS': intfRangeMatcher,
      'cable' : cableShowNode,
      'detail' : 'Display information in detail'
      }
   cliModel = InterfaceBaseTCableTestStatuses

   handler = "CableTestCliHandler.showIntfCableDetailHander"

BasicCli.addShowCommandClass( ShowIntfCableDetail )

def Plugin( entityManager ):
   gv.cableTestSliceDir = LazyMount.mount(
      entityManager,
      'hardware/phy/cabletest/status/slice',
      'Tac::Dir', 'ri' )
