# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliMatcher
import CliPlugin.TechSupportCli
from CliPlugin.CdpModel import CdpNeighbors
import ShowCommand

matcherCdp = CliMatcher.KeywordMatcher( 'cdp',
                        helpdesc='Cisco Discovery Protocol (CDP) status' )
matcherNeighbors = CliMatcher.KeywordMatcher( 'neighbors',
                     helpdesc='Show CDP neighbors' )

#------------------------------------------------------------------------------------
# show cdp neighbors
#------------------------------------------------------------------------------------
class CdpNeighborsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show cdp neighbors'
   data = {
      'cdp' : matcherCdp,
      'neighbors' : matcherNeighbors,
   }
   handler = CdpNeighbors.create
   cliModel = CdpNeighbors

BasicCli.addShowCommandClass( CdpNeighborsCmd )

#------------------------------------------------------
# Register Cdp show commands into "show tech-support".
#------------------------------------------------------

# Timestamps are made up to maintain historical order within show tech-support
CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2023-01-18 00:00:00',
   cmds=[ 'show cdp neighbors' ] )
