# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AgentDirectory
import CliPlugin.TechSupportCli
import LazyMount
from Toggles.CfmToggleLib import toggleCfmSwUpMepCcmEnabled

entityManager = None
cfmHwSupportStatus = None

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2021-06-24 01:10:42',
   cmds=[ 'show cfm end-point',
          'show cfm continuity-check end-point',
          'show cfm continuity-check end-point remote-defect',
          'show cfm measurement delay proactive' ],
   cmdsGuard=lambda: AgentDirectory.agent( entityManager.sysname(), 'CfmAgent' ) )

cmds = []
cmds.append( 'show cfm measurement loss proactive' )
cmds.append( 'show cfm measurement loss synthetic proactive' )

if cmds:
   CliPlugin.TechSupportCli.registerShowTechSupportCmd(
         '2022-06-08 12:00:00',
         cmds=cmds,
         cmdsGuard=lambda: AgentDirectory.agent( entityManager.sysname(),
                                                 'CfmAgent' ) )

# This command is only supported for CfmSw and will be available
# when CfmAgent is running in CfmSw mode.
CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2023-10-12 13:33:11',
   cmds=[ 'show cfm continuity-check counters' ],
   cmdsGuard=lambda: (
      AgentDirectory.agent( entityManager.sysname(), 'CfmAgent' ) and
      toggleCfmSwUpMepCcmEnabled() and
      cfmHwSupportStatus and
      cfmHwSupportStatus.mepSwSupported() ) )

def Plugin( em ):
   global entityManager
   global cfmHwSupportStatus
   entityManager = em

   cfmHwSupportStatus = LazyMount.mount(
      entityManager, 'cfm/hwSupportStatus', 'Cfm::HwSupportStatus', 'r' )
