#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import CliGlobal
from CliMode.Clb import ClbMode
import CliToken.LoadBalance
import CliPlugin.ClbCli
from CliPlugin.ConfigConvert import registerConfigConvertCallback
import ConfigMount

gv = CliGlobal.CliGlobal( config=None )

clbConfigMatcher = CliCommand.guardedKeyword( "cluster",
                                              "Configure Cluster Load Balancing",
                                              CliPlugin.ClbCli.clbGuard )

class ClbConfigMode( ClbMode, BasicCli.ConfigModeBase ):
   def __init__( self, parent, session ):
      ClbMode.__init__( self, None )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class EnterClbMode( CliCommand.CliCommandClass ):
   syntax = "load-balance cluster"
   noOrDefaultSyntax = syntax
   data = {
      "load-balance": CliToken.LoadBalance.loadBalanceMatcherForConfig,
      "cluster": clbConfigMatcher,
   }
   handler = "ClbConfigHandlers.enterClbMode"
   noOrDefaultHandler = "ClbConfigHandlers.clearClbMode"

BasicCli.GlobalConfigMode.addCommandClass( EnterClbMode )

def clbConfigConvert( mode ):
   gv.config.forwardingModeCliTokenIpv4 = False
   for pg in gv.config.hostIntfGroup.values():
      pg.useInterfaceToken = False

def Plugin( entityManager ):
   gv.config = ConfigMount.mount( entityManager, "clb/config",
                                  "Clb::Config", "w" )
   registerConfigConvertCallback( clbConfigConvert )

