#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
from CliToken.Clear import clearKwNode
from CliToken.LoadBalance import loadBalanceMatcherForClear
import CliPlugin.ClbCli

clbClearMatcher = CliCommand.guardedKeyword(
   "cluster", "Clear Cluster Load Balancing information",
   CliPlugin.ClbCli.clbGuard )

class ClearFlowTableCommand( CliCommand.CliCommandClass ):
   syntax = "clear load-balance cluster flows"
   data = {
      "clear": clearKwNode,
      "load-balance": loadBalanceMatcherForClear,
      "cluster": clbClearMatcher,
      "flows": "Clear flows"
   }

   handler = "ClbExecHandlers.clearFlowTable"

BasicCli.EnableMode.addCommandClass( ClearFlowTableCommand )

class ClearCounterCommand( CliCommand.CliCommandClass ):
   syntax = "clear load-balance cluster counters [ session ]"
   data = {
      "clear": clearKwNode,
      "load-balance": loadBalanceMatcherForClear,
      "cluster": clbClearMatcher,
      "counters": "Clear counters",
      "session": "Only clear counters for the current login session"
   }

   handler = "ClbExecHandlers.clearCounters"

BasicCli.EnableMode.addCommandClass( ClearCounterCommand )
