# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import BasicCliUtil
import CliCommand
import CliToken.Configure

configConvertCallbacks = []

def registerConfigConvertCallback( cmdCallback ):
   """
   API used by other CliPlugins to register commands to be called when
   config convert new-syntax is called.
   """
   configConvertCallbacks.append( cmdCallback )

def execConfigConvertCmd( mode, args ):
   warningPrompt = '''
   WARNING!
   Converting existing configuration to new syntax will lose backward compatibility.
   Make sure you won't downgrade to releases that only support the old syntaxes.
   '''
   promptText = 'Proceed [ y/n ]'
   mode.addMessage( warningPrompt )
   ans = BasicCliUtil.confirm( mode, promptText, answerForReturn=False )
   if not ans:
      mode.addError( "Command aborted by user" )
      return
   for f in configConvertCallbacks:
      f( mode )

class ConfigConvertCmd( CliCommand.CliCommandClass ):
   syntax = '''configure convert new-syntax '''
   data = { 'configure': CliToken.Configure.configureParseNode,
            'convert': 'Perform configuration conversion',
            'new-syntax': 'Convert existing config to latest syntax' }
   handler = execConfigConvertCmd

BasicCli.EnableMode.addCommandClass( ConfigConvertCmd )
