# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Ark
import BasicCliSession
import CliPlugin.ConfigLockModels
import ConfigureLock

def showConfigLockHandler( mode, args ):
   userInfo = BasicCliSession.CONFIG_LOCK.getCurrUserInfo()
   result = CliPlugin.ConfigLockModels.ConfigureLockModel()
   if userInfo is None:
      return result

   result.userInfo = CliPlugin.ConfigLockModels.ConfigureLockModelUser()
   result.userInfo.username = userInfo.user
   result.userInfo.userTty = userInfo.tty
   result.userInfo.userLocation = userInfo.location
   result.userInfo.lockAcquireTime = Ark.switchTimeToUtc( userInfo.grabTime )
   result.userInfo.transactionName = userInfo.transactionName
   result.userInfo.lockAcquireReason = userInfo.acquireReason
   return result

def showConfigLockHistoryHandler( mode, args ):
   result = CliPlugin.ConfigLockModels.ConfigureLockModelHistory()
   for history in BasicCliSession.CONFIG_LOCK.getHistory():
      if history.releaseTime:
         lockReleaseTime = Ark.switchTimeToUtc( history.releaseTime )
      else:
         lockReleaseTime = None
      lockAcquireTime = Ark.switchTimeToUtc( history.grabTime )
      historyInfo = CliPlugin.ConfigLockModels.ConfigureLockModelHistoryInfo()
      historyInfo.username = history.user
      historyInfo.userTty = history.tty
      historyInfo.userLocation = history.location
      historyInfo.lockAcquireTime = lockAcquireTime
      historyInfo.lockReleaseTime = lockReleaseTime
      historyInfo.transactionName = history.transactionName
      historyInfo.lockReleaseReason = history.releaseReason
      result.history.append( historyInfo )
   return result

def configureLockCmdHandler( mode, args ):
   if BasicCliSession.CONFIG_LOCK.isLockOwner():
      mode.addWarning( 'Configure Lock is currently held by this thread/user.' )
      return

   try:
      if 'continue' not in args:
         BasicCliSession.CONFIG_LOCK.acquireLock( reason=args.get( 'REASON' ),
               transactionName=args.get( 'TRANSACTION' ) )
      else:
         BasicCliSession.CONFIG_LOCK.continueLock( reason=args.get( 'REASON' ),
               transactionName=args[ 'TRANSACTION' ] )
   except ConfigureLock.UnableToAcquireLockException as e:
      mode.addError( str( e ) )

def configureUnlockCmdHandler( mode, args ):
   if not BasicCliSession.CONFIG_LOCK.isLockedOwned():
      mode.addWarning( 'Configure Lock is currently not held.' )
      return

   try:
      BasicCliSession.CONFIG_LOCK.releaseLock( force='force' in args,
            transactionName=args.get( 'TRANSACTION' ),
            reason=args.get( 'REASON' ) )
   except ConfigureLock.UnableToReleaseLockException as e:
      mode.addError( str( e ) )
