# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import BasicCliModes
import CliCommand
import CliMatcher
import CliToken.Configure
import CliToken.Clear
import CliParserCommon
import CliPlugin.ConfigLockCli
import CliPlugin.ConfigLockModels
import CliPlugin.TechSupportCli
import ShowCommand

configKwMatcher = CliMatcher.KeywordMatcher(
   'configuration',
   helpdesc='Show configuration information' )

transactionKwMatcher = CliMatcher.KeywordMatcher( 'transaction',
      helpdesc='transaction configure lock' )
transactionMatcher = CliMatcher.PatternMatcher( CliParserCommon.namePattern,
      helpname='TRANSACTION',
      helpdesc='transaction name for configure lock' )

class ShowConfigureLockCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show configuration lock'
   data = {
            'configuration': configKwMatcher,
            'lock': 'Configure lock information',
          }
   cliModel = CliPlugin.ConfigLockModels.ConfigureLockModel
   handler = CliPlugin.ConfigLockCli.showConfigLockHandler

class ShowConfigureLockHistoryCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show configuration lock history'
   data = {
            'configuration': configKwMatcher,
            'lock': 'Configure lock information',
            'history': 'Show past lock owners'
          }
   cliModel = CliPlugin.ConfigLockModels.ConfigureLockModelHistory
   handler = CliPlugin.ConfigLockCli.showConfigLockHistoryHandler

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2019-09-03 17:15:10',
   cmds=[ 'show configuration lock history' ] )

class ConfigureLockCmd( CliCommand.CliCommandClass ):
   syntax = 'configure lock [ [ continue ] transaction TRANSACTION ] [ REASON ]'
   data = {
            'configure': CliToken.Configure.configureParseNode,
            'lock': 'Acquire the configure lock',
            'continue': 'Continue a transaction',
            'transaction': transactionKwMatcher,
            'TRANSACTION': transactionMatcher,
            'REASON': CliMatcher.StringMatcher( helpname='REASON',
               helpdesc='Reason for acquiring the lock' )
          }
   handler = CliPlugin.ConfigLockCli.configureLockCmdHandler

class ConfigureUnlockCmd( CliCommand.CliCommandClass ):
   syntax = 'configure unlock [ transaction TRANSACTION ] [ force ] [ REASON ]'
   data = {
            'configure': CliToken.Configure.configureParseNode,
            'unlock': 'Remove the configure lock',
            'transaction': transactionKwMatcher,
            'TRANSACTION': transactionMatcher,
            'force': 'Force releasing the configure lock',
            'REASON': CliMatcher.StringMatcher( helpname='REASON',
               helpdesc='Reason for releasing the lock' )
          }
   handler = CliPlugin.ConfigLockCli.configureUnlockCmdHandler

BasicCli.addShowCommandClass( ShowConfigureLockCmd )
BasicCli.addShowCommandClass( ShowConfigureLockHistoryCmd )

# only add the commands to enable mode, and not unpriv mode
BasicCliModes.EnableMode.addCommandClass( ConfigureLockCmd )
BasicCliModes.EnableMode.addCommandClass( ConfigureUnlockCmd )
