# Copyright (c) 2008-2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
from CliMode.Mgmt import ManagementMode
import CliMatcher

managementKwMatcher = CliMatcher.KeywordMatcher( 'management',
   helpdesc='Configure management services' )
managementClearKwMatcher = CliMatcher.KeywordMatcher(
   'management', helpdesc='Clear data for management services' )
managementShowKwMatcher = CliMatcher.KeywordMatcher(
   'management', helpdesc='Show management services' )

apiKwMatcher = CliMatcher.KeywordMatcher( 'api',
   helpdesc='Configure management APIs for the switch' )

idleTimeoutKwMatcher = CliMatcher.KeywordMatcher( 'idle-timeout',
   helpdesc='Set idle session timeout (minutes)' )
idleTimeoutMatcher = CliMatcher.IntegerMatcher( 0, 86400,
   helpdesc='Idle session timeout in minutes' )

class ConfigMgmtMode( ManagementMode, BasicCli.ConfigModeBase ):

   def __init__( self, parent, session, serviceName ):
      ManagementMode.__init__( self, serviceName )
      BasicCli.ConfigModeBase.__init__( self, parent, session )
      self.serviceName = serviceName
