#!/usr/bin/env python3
# Copyright (c) 2008-2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli, LazyMount, os, Tac, Cell
import BasicCliModes
import CliCommand
import CliPlugin.TechSupportCli
from CliPlugin import CoredumpControlModel
import ConfigMount
from CliToken.System import systemMatcherForConfig
import CliMatcher
import ShowCommand

#------------------------------------------------------------------------------------
# The "coredump" commands, in config mode.
# system coredump COMPRESSION_TYPE
# no system coredump
# default system coredump
#------------------------------------------------------------------------------------

coredumpConfig = None
coredumpStatus = None

def coredumpConfigIs( mode, args ):
   coredumpConfig.mode = args.get( 'COMPRESSION_TYPE', 'compressed' )

def noCoredumpConfig( mode, args ):
   coredumpConfig.mode = 'disabled'

#--------------------------------------------------------------------------------
# [ no | default ] system coredump COMPRESSION_TYPE
#--------------------------------------------------------------------------------
class SystemCoredumpCompressedCmd( CliCommand.CliCommandClass ):
   syntax = 'system coredump COMPRESSION_TYPE'
   noOrDefaultSyntax = 'system coredump ...'
   data = {
      'system': systemMatcherForConfig,
      'coredump': 'Configure corefile dumping on the system',
      'COMPRESSION_TYPE': CliMatcher.EnumMatcher( {
          'compressed': 'Enable coredump with run-time compression \
          (delays process-restart)',
          'defercompress': 'Enable coredump with deferred compression'
      } ) 
   }
   handler = coredumpConfigIs
   defaultHandler = handler
   noHandler = noCoredumpConfig

BasicCliModes.GlobalConfigMode.addCommandClass( SystemCoredumpCompressedCmd )

def showCoreDump( mode, args ):
   model = CoredumpControlModel.SystemCoreDump()
   model.mode = coredumpStatus.mode 
   if coredumpStatus.mode != "disabled":
      model.coreFiles = os.listdir( "/var/core" )
   return model

#-----------------------------------------------------------------------------------
# show system coredump
#-----------------------------------------------------------------------------------
class ShowSystemCoredump( ShowCommand.ShowCliCommandClass ):
   syntax = 'show system coredump'
   data = {
            'system': 'Show system status',
            'coredump': 'Show the coredump settings and corefiles',
          }
   cliModel = CoredumpControlModel.SystemCoreDump
   handler = showCoreDump

BasicCli.addShowCommandClass( ShowSystemCoredump )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2020-05-10 23:59:59',
   summaryCmds=[ 'show system coredump' ] )

def Plugin( entityManager ):
   global coredumpConfig
   global coredumpStatus
   coredumpConfig = ConfigMount.mount( entityManager, "sys/coredump/config",
                                       "System::CoredumpControlConfig", "w" )
   coredumpStatus = LazyMount.mount( entityManager, \
                                     Cell.path( "sys/coredump/status" ),
                                     "System::CoredumpControlStatus", "r" )

