#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import ShowCommand
# pylint: disable-next=consider-using-from-import
import CliPlugin.DebugMessageCli as DebugMessageCli
from CliToken.Debugging import debuggingMatcherForShow

#--------------------------------------------------------------------------------
# show debugging
#--------------------------------------------------------------------------------
class DebuggingCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show debugging'
   data = {
      'debugging' : debuggingMatcherForShow,
   }
   handler = DebugMessageCli.showDebug

BasicCli.addShowCommandClass( DebuggingCmd )
