# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AgentCommandRequest
import AgentDirectory
import BasicCli
import DhcpRelayAgent
import ShowCommand
import CliPlugin.DhcpSnoopingCli as DhcpSnoopingCli
from CliPlugin.TechSupportCli import ( techSupportKwMatcher,
                                       extendedKwMatcher,
                                       registerShowTechSupportCmd )

def isDhcpRelayAgentRunning( sysname ):
   agentName = DhcpRelayAgent.name
   return AgentDirectory.agentIsRunning( sysname, agentName )

def doShowTechDhcpRelay( mode, args ):
   if isDhcpRelayAgentRunning( mode.entityManager.sysname() ):
      command = 'DUMP_DHCPRELAY_STATE'
      AgentCommandRequest.runSocketCommand( mode.entityManager,
                                            DhcpRelayAgent.name,
                                            "DhcpRelayDump",
                                            command )
   else:
      mode.addWarning( "DhcpRelay agent is not active" )

#------------------------------------------------------------
# Register DhcpRelay show commands into "show tech-support"
#------------------------------------------------------------
cmdDhcpRelayCountersV4 = [ 'show ip dhcp relay counters' ]
cmdDhcpRelayCountersV6 = [ 'show ipv6 dhcp relay counters' ]
cmdDhcpRelay = [ 'show ip dhcp relay' ]
cmdsDhcpSnoopingV4 = [ 'show ip dhcp snooping counters detail' ]
cmdsDhcpSnoopingV6 = [ 'show ipv6 dhcp snooping counters detail' ]

cmdsDhcpRelay = cmdDhcpRelay + cmdDhcpRelayCountersV4 + cmdDhcpRelayCountersV6


# Register Command
# Note: Timestamps are used to maintain order within show tech-support
registerShowTechSupportCmd( '2021-03-07 12:00:00',
                            cmds=cmdsDhcpRelay )

# These commands must be guarded, since they are only available on 
# specific platforms
registerShowTechSupportCmd( '2021-03-07 12:00:10',
                            cmds=cmdsDhcpSnoopingV4,
                            cmdsGuard=DhcpSnoopingCli.dhcpSnoopingSupported )

registerShowTechSupportCmd( '2021-03-07 12:00:20',
                            cmds=cmdsDhcpSnoopingV6,
                            cmdsGuard=DhcpSnoopingCli.dhcp6SnoopingSupported )

#----------------------------------------------------------------
# show tech-support extended dhcp-relay
#----------------------------------------------------------------
class TechSupportExtendedDhcpRelayCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show tech-support extended dhcp-relay'
   data = {
         'tech-support' : techSupportKwMatcher,
         'extended' : extendedKwMatcher,
         'dhcp-relay' : 'Show detailed state of DhcpRelay Agent',
   }
   handler = doShowTechDhcpRelay
   privileged = True

BasicCli.addShowCommandClass( TechSupportExtendedDhcpRelayCmd )
