# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
from CliToken.Flow import flowMatcherForShow
from CliPlugin.FlowTrackingCliLib import (
   countersKw,
   trackingShowKw,
   cpuQueueShowKw,
)
import ShowCommand

class ShowFlowTrackingCpuQueueCounters( ShowCommand.ShowCliCommandClass ):
   syntax = 'show flow tracking cpu-queue counters'

   data = {
         'flow': flowMatcherForShow,
         'tracking': trackingShowKw,
         'cpu-queue': cpuQueueShowKw,
         'counters': countersKw,
   }

   cliModel = "DmaMonitorModel.CountersModel"
   handler = "DmaMonitorCliHandler.showFlowTrackingCpuQueueCounters"

BasicCli.addShowCommandClass( ShowFlowTrackingCpuQueueCounters )
