# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import CliMatcher
import CliToken
import ConfigMount
import LazyMount
from Intf.IntfRange import IntfRangeMatcher
from CliPlugin import ConfigMgmtMode
from CliPlugin import EthIntfCli
from CliPlugin import LagIntfCli
from CliPlugin import IntfCli
from CliPlugin import DmfCli

import Tac

config = None
indigoStatus = None

indigoMatcher = CliMatcher.KeywordMatcher( "indigo",
                                           helpdesc="DMF Indigo agent" )
dmfIntfRangeMatcher = IntfRangeMatcher( explicitIntfTypes=(
                                           EthIntfCli.EthPhyAutoIntfType,
                                           LagIntfCli.LagAutoIntfType, ) )

###################################################################
# clear management dmf indigo packets
##################################################################
def clearDmfIndigoPacketCounters( mode ):
   config.clearPacketManagerCounterRequestTime = Tac.now()

class ClearDmfIndigoPacketsCmd( CliCommand.CliCommandClass ):
   syntax = "clear management dmf indigo packets"
   data = {
      "clear": CliToken.Clear.clearKwNode,
      "management": ConfigMgmtMode.managementClearKwMatcher,
      "dmf": DmfCli.dmfMatcher,
      "indigo": indigoMatcher,
      "packets": "Clear packet counters trapped or injected to/by the controller",
   }

   @staticmethod
   def handler( mode, args ):
      clearDmfIndigoPacketCounters( mode )

BasicCli.EnableMode.addCommandClass( ClearDmfIndigoPacketsCmd )

def clearDmfInterfacePortCounters( mode, intfs=None ):
   if not intfs and indigoStatus.portCountersDir:
      intfs = { portCounter.intfId for portCounter
                in indigoStatus.portCountersDir.portCounters.values() }

   requestTime = Tac.now()
   for intfId in intfs:
      config.clearPortCounterRequestTime[ intfId ] = requestTime

class ClearDmfInterfacePacketsCmd( CliCommand.CliCommandClass ):
   syntax = "clear management dmf interfaces [ INTS ] counters"
   data = {
      "clear": CliToken.Clear.clearKwNode,
      "management": ConfigMgmtMode.managementClearKwMatcher,
      "dmf": DmfCli.dmfMatcher,
      "interfaces": "DMF interfaces",
      "INTS": dmfIntfRangeMatcher,
      "counters": "Clear interface ingressing/egressing packet counters",
   }

   @staticmethod
   def handler( mode, args ):
      if not indigoStatus.portCountersDir:
         return

      intfs = None
      intRange = args.get( "INTS" )
      if intRange:
         intfs = IntfCli.Intf.getAll( mode, intRange )
         intfs = { x.ethIntfConfig.intfId for x in intfs }

      clearDmfInterfacePortCounters( mode, intfs )

BasicCli.EnableMode.addCommandClass( ClearDmfInterfacePacketsCmd )

class ClearDmfAllCounters( CliCommand.CliCommandClass ):
   syntax = "clear management dmf counters"
   data = {
      "clear": CliToken.Clear.clearKwNode,
      "management": ConfigMgmtMode.managementClearKwMatcher,
      "dmf": DmfCli.dmfMatcher,
      "counters": "Clear all DMF ingressing/egressing packet counters",
   }

   @staticmethod
   def handler( mode, args ):
      DmfCli.clearDmfFlowTableCounters( mode )
      DmfCli.clearDmfFlowTableCounters( mode, egress=True )
      clearDmfIndigoPacketCounters( mode )
      clearDmfInterfacePortCounters( mode )

BasicCli.EnableMode.addCommandClass( ClearDmfAllCounters )

def Plugin( entityManager ):
   global config
   global indigoStatus

   config = ConfigMount.mount( entityManager,
                               "dmf/cli/config",
                               "Dmf::Cli::Config", "w" )
   indigoStatus = LazyMount.mount( entityManager,
                                   "dmf/indigo/status",
                                   "Dmf::Indigo::Status", "r" )
