#!/usr/bin/env python3
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Arnet
import CliPlugin.IntfCli as IntfCli # pylint: disable=consider-using-from-import
# pylint: disable-next=consider-using-from-import
import CliPlugin.EthIntfCli as EthIntfCli
from CliModel import Dict, Model

class PortIDs( Model ):

   portIDs = Dict( keyType=str, valueType=int,
                   help='Map an interface name to a port id' )

   def render( self ):
      for name in Arnet.sortIntf( self.portIDs ):
         # pylint: disable-next=consider-using-f-string
         print( '%s:  Port ID = %d' % ( name, self.portIDs[ name ] ) )

#-------------------------------------------------------------------------------
# The "show snmp mib bridgemib portid [interfaceName]" command, in "enable" mode.
#-------------------------------------------------------------------------------

def showSnmpPortId( mode, args ):

   intf = args.get( 'INTF' )

   intfs = IntfCli.Intf.getAll( mode, intf, None, EthIntfCli.EthIntf )
   if not intfs:
      return PortIDs()

   intfs = [ i for i in intfs if i.lookup() ]
   if not intfs:
      return PortIDs()

   portIDs = {}
   for i in intfs:
      portIDs[ i.name ] = i.status().portId

   return PortIDs( portIDs=portIDs )

