#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliMatcher
from CliPlugin import InstallCli
from CliToken.Install import installMatcher, sourceMatcher, reloadMatcher, nowMatcher
from Url import UrlMatcher, getFilesystem

import os

def getSupportedExtNames():
   extFiles = set()
   extDir = getFilesystem( 'extension:' ).location_
   extDataFile = '/export/swi/extension-data'

   if os.path.exists( extDir ):
      extFiles.update( os.listdir( extDir ) )

   if os.path.exists( extDataFile ):
      with open( extDataFile, 'r' ) as f:
         extFiles.update( f.read().splitlines() )

   return sorted( extFiles )

extNamePattern = r'(^(?!all$))([A-Za-z0-9_.:+-]+)'
extNameMatcher = CliMatcher.DynamicNameMatcher( lambda mode: getSupportedExtNames(),
                                                "Extension Name",
                                                pattern=extNamePattern )

#--------------------------------------------------------------------------------
# install source SOURCE [ destination DESTINATION ] [ reload ] [ now ]
#--------------------------------------------------------------------------------
class InstallSourceCmd( CliCommand.CliCommandClass ):
   syntax = ( 'install source SOURCE [ destination DESTINATION ]'
              '[ ( extension all ) | { extension EXTENSION } ] [ reload ] [ now ]' )
   data = {
      'install': installMatcher,
      'source': sourceMatcher,
      'SOURCE': UrlMatcher( fsFunc=lambda fs: fs.scheme != 'system:',
                            helpdesc='Source path', allowAllPaths=True ),
      'destination': 'Provide a destination path',
      'DESTINATION': UrlMatcher( fsFunc=lambda fs: fs.scheme == 'flash:',
                                 helpdesc='Destination path' ),
      'reload': reloadMatcher,
      'now': nowMatcher,
      'extension': 'Extension name to keep in source software image.',
      'all': 'Keep all extensions in source software image',
      'EXTENSION': extNameMatcher,
   }
   handler = InstallCli.doInstall

BasicCliModes.EnableMode.addCommandClass( InstallSourceCmd )
