# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import ShowCommand
import CliMatcher
from CliPlugin import IpAddrMatcher

from CliPlugin.DaemonCli import DaemonCliMode

# ###############################################################################
# ################# Cli_Command_Definitions #####################################
# ###############################################################################

# --------------------------------------------------------------------------------
# daemon <name>; cli; route add
# --------------------------------------------------------------------------------


class DaemonCliRouteAddCmd( CliCommand.CliCommandClass ):
   syntax = 'route add <target> <gateway>'
   data = {
      'route': "work on agent's configured routes",
      'add': 'add a route',
      '<target>': IpAddrMatcher.ipPrefixMatcher,
      '<gateway>': IpAddrMatcher.ipAddrMatcher,
   }
   handler = "EosSdkCliHandler.doRouteAdd_handler"

DaemonCliMode.addCommandClass( DaemonCliRouteAddCmd )

# -------------------------------------------------------------------------------
# daemon <name>; cli; route del
# --------------------------------------------------------------------------------


class DaemonCliRouteDelCmd( CliCommand.CliCommandClass ):
   syntax = 'route del <target> [<gateway>]'
   data = {
      'route': "work on agent's configured routes",
      'del': 'delete a route',
      '<target>': IpAddrMatcher.ipPrefixMatcher,
      '<gateway>': IpAddrMatcher.ipAddrMatcher,
   }
   handler = "EosSdkCliHandler.doRouteDel_handler"

DaemonCliMode.addCommandClass( DaemonCliRouteDelCmd )

# --------------------------------------------------------------------------------
# daemon <name>; cli; show routes
# --------------------------------------------------------------------------------


class DaemonCliRouteShowCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'route show_'
   data = {
      'route': "work on agent's configured routes",
      'show_': CliMatcher.KeywordMatcher( 'show',
                                          helpdesc="display the agent's routes" ),
   }
   handler = "EosSdkCliHandler.doRouteShow_handler"

DaemonCliMode.addShowCommandClass( DaemonCliRouteShowCmd )


def Plugin( entityManager ):
   pass
