# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell
import Plugins
from CliPlugin.HealthCliLib import HealthStatusReactor

healthEventHandlers = {}
def registerHealthEventHandler( handlerArgs ):
   name = handlerArgs[ 0 ]
   healthEventHandlers.update( { name : handlerArgs } )

class HealthEventHandlerInstaller( HealthStatusReactor ):
   def __init__( self, healthStatus, eventConfig, redStatus ):
      self.eventConfig_ = eventConfig
      self.redStatus_ = redStatus
      HealthStatusReactor.__init__( self, healthStatus )

   def handleEnabled( self ):
      if self.redStatus_.mode != 'active':
         return
      for name, handlerArgs in healthEventHandlers.items():
         self.eventConfig_.event.newMember( *handlerArgs )
         self.eventConfig_.event[ name ].builtinHandler = True

   def handleDisabled( self ):
      if self.redStatus_.mode != 'active':
         return
      for name in healthEventHandlers:
         del self.eventConfig_.event[ name ]

@Plugins.plugin( provides=( 'HealthEventHandlerInstaller', ) )
def Plugin( entityManager ):
   mg = entityManager.mountGroup()
   redStatus = entityManager.lookup( Cell.path( 'redundancy/status' ) )
   healthStatus = mg.mount( "health/status", "Health::Status", "r" )
   eventConfig = mg.mount( "sys/event/config", "Event::Config", "w" )

   def _setupHealthEventHandlerInstaller():
      entityManager.healthEventHandlerInstaller = \
         HealthEventHandlerInstaller( healthStatus, eventConfig, redStatus )

   mg.close( _setupHealthEventHandlerInstaller )
