# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
from CliPlugin.EventHealthLib import registerHealthEventHandler
from Tac import Type

typeDefaultCommand = Type( "Event::Config" ).defaultCommand
# Fan event handlers
# FanFailureEventHandler monitors fan failure on all fans.
fanFailureHandler = (
   'FanFailureEventHandler',
   'onCounters',               # Event::TriggerType triggerType
   False,                      # bool operstatus
   False,                      # bool ip
   False,                      # bool ip6
   "",                         # Tac::String triggerVariable
   'actionKindBash',           # Event::ActionKind actionKindBash
   typeDefaultCommand,         # Tac::String command
   0,                          # const Seconds& delay
   0,                          # const Seconds& repeatInterval
   1,                          # U32 maxActionCount
   False,                      # bool asynchronous
   20,                         # const Seconds& timeout
   1,                          # U32 thresholdCount
   0,                          # const Seconds& threshold
   30,                         # const Seconds& pollInterval
   "*.fanFailure == 1",
                               # fan health monitoring condition
   "",                         # Tac::String logRegex
   "",                         # Tac::String maintenanceUnitName
   "",                         # Tac::String maintenanceOper
   "",                         # Tac::String maintenanceStage
   "",                         # Tac::String maintenanceBgpPeer
   "",                         # Tac::String vrfName
   "cooling",                  # Tac::String metricName
   True, # bool runUponConfig
   "" )                      # Tac::String scriptTrigger

# FanEventHandler monitors fan stability on all fans that are not PowerSupply fans.
fanHandler = (
   'FanEventHandler',
   'onCounters',               # Event::TriggerType triggerType
   False,                      # bool operstatus
   False,                      # bool ip
   False,                      # bool ip6
   "",                         # Tac::String triggerVariable
   'actionKindBash',           # Event::ActionKind actionKindBash
   typeDefaultCommand,         # Tac::String command
   0,                          # const Seconds& delay
   0,                          # const Seconds& repeatInterval
   1,                          # U32 maxActionCount
   False,                      # bool asynchronous
   20,                         # const Seconds& timeout
   1,                          # U32 thresholdCount
   0,                          # const Seconds& threshold
   30,                         # const Seconds& pollInterval
   "*.percentBelowTargetFanSpeed > 20 or *.percentAboveTargetFanSpeed > 20",
                               # fan health monitoring condition
   "",                         # Tac::String logRegex
   "",                         # Tac::String maintenanceUnitName
   "",                         # Tac::String maintenanceOper
   "",                         # Tac::String maintenanceStage
   "",                         # Tac::String maintenanceBgpPeer
   "",                         # Tac::String vrfName
   "cooling",                  # Tac::String metricName
   True, # bool runUponConfig
   "" )                      # Tac::String scriptTrigger

# powerSupply event handler
powerSupplyHandler = (
   'PowerSupplyEventHandler',
   'onCounters',               # Event::TriggerType triggerType
   False,                      # bool operstatus
   False,                      # bool ip
   False,                      # bool ip6
   "",                         # Tac::String triggerVariable
   'actionKindBash',           # Event::ActionKind actionKindBash
   typeDefaultCommand,         # Tac::String command
   0,                          # const Seconds& delay
   0,                          # const Seconds& repeatInterval
   1,                          # U32 maxActionCount
   False,                      # bool asynchronous
   20,                         # const Seconds& timeout
   1,                          # U32 thresholdCount
   0,                        # const Seconds& threshold
   30,                         # const Seconds& pollInterval
   "*.PSUFailure == 1 ",
                               # psu health monitoring condition
   "",                         # Tac::String logRegex
   "",                         # Tac::String maintenanceUnitName
   "",                         # Tac::String maintenanceOper
   "",                         # Tac::String maintenanceStage
   "",                         # Tac::String maintenanceBgpPeer
   "",                         # Tac::String vrfName
   "power",                    # Tac::String metricName
   True, # bool runUponConfig
   "" )                      # Tac::String scriptTrigger

# Voltage event handler
voltageHandler = (
   'VoltageEventHandler',
   'onCounters',               # Event::TriggerType triggerType
   False,                      # bool operstatus
   False,                      # bool ip
   False,                      # bool ip6
   "",                         # Tac::String triggerVariable
   'actionKindBash',           # Event::ActionKind actionKindBash
   typeDefaultCommand,         # Tac::String command
   0,                          # const Seconds& delay
   0,                          # const Seconds& repeatInterval
   1,                          # U32 maxActionCount
   False,                      # bool asynchronous
   20,                         # const Seconds& timeout
   5,                          # U32 thresholdCount
   300,                        # const Seconds& threshold
   30,                         # const Seconds& pollInterval
   "*.percentBelowMarginLowVoltage > 10 or *.percentAboveMarginHighVoltage > 10",
                               # sensor health monitoring condition
   "",                         # Tac::String logRegex
   "",                         # Tac::String maintenanceUnitName
   "",                         # Tac::String maintenanceOper
   "",                         # Tac::String maintenanceStage
   "",                         # Tac::String maintenanceBgpPeer
   "",                         # Tac::String vrfName
   "voltage",                  # Tac::String metricName
   True, # bool runUponConfig
   "" )                      # Tac::String scriptTrigger


# Temperature event handler
temperatureHandler = (
   'TemperatureEventHandler',
   'onCounters',               # Event::TriggerType triggerType
   False,                      # bool operstatus
   False,                      # bool ip
   False,                      # bool ip6
   "",                         # Tac::String triggerVariable
   'actionKindBash',           # Event::ActionKind actionKindBash
   typeDefaultCommand,         # Tac::String command
   0,                          # const Seconds& delay
   0,                          # const Seconds& repeatInterval
   1,                          # U32 maxActionCount
   False,                      # bool asynchronous
   20,                         # const Seconds& timeout
   1,                          # U32 thresholdCount
   0,                          # const Seconds& threshold
   30,                         # const Seconds& pollInterval
   "*.temperature > *.overheatTemperature or *.tempSensorFailure == 1",
                               # trigger condition
   "",                         # Tac::String logRegex
   "",                         # Tac::String maintenanceUnitName
   "",                         # Tac::String maintenanceOper
   "",                         # Tac::String maintenanceStage
   "",                         # Tac::String maintenanceBgpPeer
   "",                         # Tac::String vrfName
   "temperature",              # Tac::String metricName
   True, # bool runUponConfig
   "" )                      # Tac::String scriptTrigger

@Plugins.plugin( requires=( 'HealthEventHandlerInstaller', ) )
def Plugin( entityManager ):
   registerHealthEventHandler( fanFailureHandler )
   registerHealthEventHandler( fanHandler )
   registerHealthEventHandler( powerSupplyHandler )
   registerHealthEventHandler( temperatureHandler )
   registerHealthEventHandler( voltageHandler )
