#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliPlugin.EventCli as EventCli # pylint: disable=consider-using-from-import

#--------------------------------------------------------------------------------
# [ no | default ] event-handler EVENT_HANDLER
#--------------------------------------------------------------------------------
class EventHandlerCmd( CliCommand.CliCommandClass ):
   syntax = 'event-handler EVENT_HANDLER'
   noOrDefaultSyntax = 'event-handler EVENT_HANDLER ...'
   data = {
      'event-handler': 'Event-handler config commands',
      'EVENT_HANDLER': EventCli.eventHandlerNameMatcher
   }
   handler = EventCli.gotoEventHandlerConfigMode
   noOrDefaultHandler = EventCli.destroyEventHandler

BasicCliModes.GlobalConfigMode.addCommandClass( EventHandlerCmd )
