# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
# pylint: disable-next=consider-using-from-import
import CliPlugin.HttpService as HttpService
import CliPlugin.VrfCli as VrfCli # pylint: disable=consider-using-from-import
from CliPlugin import ConfigMgmtMode
import CliGlobal
import BasicCli
import ConfigMount
from CliMode.ExternalHttpServices import ExternalHttpServicesVrfConfigModeBase

# -----------------------------------------------------------------------------------
# Mount path holders ( Define all mount path holders here )
# -----------------------------------------------------------------------------------
gv = CliGlobal.CliGlobal(
   dict(
      capiConfig=None,
   )
)

class ExternalHttpServicesConfigMode( ConfigMgmtMode.ConfigMgmtMode ):
   name = "External HTTP services configuration"

   def __init__( self, parent, session ):
      ConfigMgmtMode.ConfigMgmtMode.__init__( self, parent, session,
                                              "api-external-services" )
      self.config_ = gv.capiConfig

   def enterCmd( self ):
      return "management api external-services"

#--------------------------------------------------------------------
# The "[no|default] management api external-services" mode command.
#--------------------------------------------------------------------
class EnterExternalHttpServicesMode( CliCommand.CliCommandClass ):
   syntax = """management api external-services"""
   noOrDefaultSyntax = syntax

   data = { "management": ConfigMgmtMode.managementKwMatcher,
            "api": ConfigMgmtMode.apiKwMatcher,
            "external-services": ( "Configure the external(customer specific) "
                                   "web services on HTTP server" )}

   handler = "ExternalHttpServicesHandler.enterExternalHttpServicesModeHandler"
   noOrDefaultHandler = "ExternalHttpServicesHandler.enterEHSModeNoOrDefaultHandler"

BasicCli.GlobalConfigMode.addCommandClass( EnterExternalHttpServicesMode )

#-------------------------------------------------------------------
# The "[no|default] shutdown" command in "management api external-services" mode
#-------------------------------------------------------------------
class ConfigureExternalHttpServices( CliCommand.CliCommandClass ):
   syntax = """shutdown"""
   noOrDefaultSyntax = syntax

   data = { "shutdown": "Disable external HTTP services access" }

   handler = "ExternalHttpServicesHandler.shutdownExternalHttpServicesHandler"
   defaultHandler = handler # by default we are off
   noHandler = "ExternalHttpServicesHandler.shutdownExternalHttpServicesNoHandler"

ExternalHttpServicesConfigMode.addCommandClass( ConfigureExternalHttpServices )

#-------------------------------------------------------------------------------
# The "[no | default] shutdown" command,
# in "vrf <vrf name>" mode
# under "management api external-services" mode.
#-------------------------------------------------------------------------------
class ExternalHttpServicesVrfConfigMode( ExternalHttpServicesVrfConfigModeBase,
                                         BasicCli.ConfigModeBase ):
   name = "External services VRF configuration"

   def __init__( self, parent, session, vrfName ):
      ExternalHttpServicesVrfConfigModeBase.__init__( self, ( vrfName,
                                                             gv.capiConfig ) )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class VrfModeShutdown( CliCommand.CliCommandClass ):
   syntax = '''shutdown'''
   noOrDefaultSyntax = '''shutdown ...'''
   data = { 'shutdown': HttpService.vrfShutdownHelpdesc }

   handler = "ExternalHttpServicesHandler.vrfModeShutdownHandler"
   noHandler = "ExternalHttpServicesHandler.vrfModeShutdownNoHandler"
   defaultHandler = handler

ExternalHttpServicesVrfConfigMode.addCommandClass( VrfModeShutdown )

class EnterVrfMode( CliCommand.CliCommandClass ):
   syntax = '''vrf VRF'''
   noOrDefaultSyntax = '''vrf [ VRF ]'''
   data = { 'vrf': HttpService.vrfHelpdesc,
            'VRF': VrfCli.VrfNameExprFactory( inclDefaultVrf=True ) }
   handler = "ExternalHttpServicesHandler.enterExternalHttpServicesVrfConfigMode"
   noOrDefaultHandler = "ExternalHttpServicesHandler.removeExternalServiceVrfs"

ExternalHttpServicesConfigMode.addCommandClass( EnterVrfMode )

def Plugin( entityManager ):
   gv.capiConfig = ConfigMount.mount( entityManager,
                                      "mgmt/capi/config",
                                      "HttpService::Config",
                                      "w" )
