#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliPlugin.TechSupportCli
from AgentDirectory import agentIsRunning

sysname = None

#-------------------------------------------------------------------------------
# Firewall commands in 'show tech-support'
#-------------------------------------------------------------------------------
CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2019-08-01 09:30:04',
   cmds=[ 'show segment-security',
          'show segment-security policy',
          'show segment-security application' ],
   cmdsGuard=lambda: agentIsRunning( sysname, 'Firewall' ) )

def Plugin( entityManager ):
   global sysname
   sysname = entityManager.sysname()
