# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
from CliToken.Agent import agentKwForConfig
from CliToken.Clear import clearKwNode
from CliToken.Monitor import monitorMatcher, monitorMatcherForClear
from CliPlugin.FlowWatcherCliLib import guardMonitorSecurity

# --------------------------------------------------------------------------
# "[no|default] monitor security awake"  in config mode
# --------------------------------------------------------------------------
class MonitorSecurityAwakeConfigCmd( CliCommand.CliCommandClass ):
   syntax = '''monitor security awake'''
   noOrDefaultSyntax = syntax

   data = {
         'monitor': monitorMatcher,
         'security': CliCommand.guardedKeyword( 'security',
                           helpdesc='Configure monitor security',
                           guard=guardMonitorSecurity ),
         'awake': 'Configure monitor security awake feature'
   }

   handler = 'FlowWatcherCli.monitorSecurityAwakeConfigCmdHandler'
   noOrDefaultHandler = 'FlowWatcherCli.monitorSecurityAwakeConfigCmdNoHandler'

# -------------------------------------------------------------------------------
# "clear monitor security awake counters | ( memory statistics )"
# -------------------------------------------------------------------------------
class MsaClearCmd( CliCommand.CliCommandClass ):
   syntax = 'clear monitor security awake counters | ( memory statistics )'
   data = {
      'clear': clearKwNode,
      'monitor': monitorMatcherForClear,
      'security': CliCommand.guardedKeyword( 'security',
                                             helpdesc='Monitor security',
                                             guard=guardMonitorSecurity ),
      'awake': 'Monitor security awake feature',
      'counters': 'Monitor security awake counters',
      'memory': 'Monitor security awake memory',
      'statistics': 'Monitor security awake memory statistics',
   }

   handler = 'FlowWatcherCli.msaClearCmdHandler'

BasicCli.GlobalConfigMode.addCommandClass( MonitorSecurityAwakeConfigCmd )
BasicCli.EnableMode.addCommandClass( MsaClearCmd )

# -------------------------------------------------------------------------------
# "[no|default] agent flowwatcher threads ( single | ( dpi tx ) )"
# -------------------------------------------------------------------------------
class SetThreadConfigCmd( CliCommand.CliCommandClass ):
   syntax = 'agent flowwatcher threads ( single | ( dpi tx ) )'
   noOrDefaultSyntax = 'agent flowwatcher threads ...'
   data = {
      'agent': agentKwForConfig,
      # The 'flowwatcher' keyword must be hidden in order to prevent duplicate help
      # tokens. "agent ?" should only show "WORD   Agent name", which covers the
      # FlowWatcher agent, so there is no need for an additional 'flowwatcher' help
      # token. The tokens starting with 'threads' are not hidden and work as usual.
      'flowwatcher': CliCommand.guardedKeyword( 'flowwatcher', 'FlowWatcher agent',
                                                guardMonitorSecurity, hidden=True ),
      'threads': 'Define threading model',
      'single': 'Enable single-threaded mode',
      'dpi': 'Enable multi-threaded mode with deep packet inspection threads',
      'tx': 'Enable multi-threaded mode with transmission threads',
   }
   handler = "FlowWatcherCli.threadConfigCmdHandler"
   noOrDefaultHandler = "FlowWatcherCli.noOrDefaultThreadConfigCmdHandler"

BasicCli.GlobalConfigMode.addCommandClass( SetThreadConfigCmd )
