# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=unused-import
from Ark import (
   switchTimeToUtc,
   utcTimeRelativeToNowStr,
)
# pylint: enable=unused-import
import CliGlobal
import CliMatcher
import CliParser
import LazyMount
import Shark
import SharkLazyMount
from TypeFuture import TacLazyType

# Global variable holder.
gv = CliGlobal.CliGlobal(
   dict(
      fwConfig=None,
      hwCapabilities=None,
      nucleusStatusColl=None,
   ) )

FlowWatcherConstants = TacLazyType( "FlowWatcher::Constants" )
FlowWatcherInactiveReason = TacLazyType( "FlowWatcher::InactiveReason" )
FlowWatcherInactiveReasonEnum = TacLazyType( "FlowWatcher::InactiveReasonEnum" )
IpGenAddr = TacLazyType( "Arnet::IpGenAddr" )
IpProtoType = TacLazyType( 'Arnet::IpProtocolNumber' )
MirroringConstants = TacLazyType( "Mirroring::Constants" )
NucleusInactiveReasonEnum = TacLazyType( "FlowWatcher::NucleusInactiveReasonEnum" )
SysUtil = TacLazyType( "Dpi::SysUtil" )

def guardMonitorSecurity( mode, token ):
   if gv.hwCapabilities.awakeSupported:
      return None
   else:
      return CliParser.guardNotThisPlatform

def guardMonitorSecurityForShowTech():
   # only run show-tech handlers if supported by hardware and feature is enabled
   # by configuration, to avoid loading handlers and models during periodic show-tech
   return gv.hwCapabilities.awakeSupported and gv.fwConfig.enabled

def getNucleusName( mode ):
   return list( gv.nucleusStatusColl.status ) if gv.nucleusStatusColl else []

nucleusNameMatcher = CliMatcher.DynamicNameMatcher( getNucleusName,
                                                    "Nucleus name" )

def Plugin( em ):
   gv.fwConfig = LazyMount.mount( em, 'flowwatcher/config',
                                  'FlowWatcher::Config', 'r' )
   gv.hwCapabilities = LazyMount.mount(
      em,
      "hardware/flowwatcher/capabilities",
      "HwFlowWatcher::Capabilities",
      "r" )
   gv.nucleusStatusColl = SharkLazyMount.mount(
      em,
      "flowwatcher/nucleusStatus",
      "FlowWatcher::NucleusStatusColl",
      Shark.mountInfo( "shadow" ),
      True, # autoUnmount
      unmountTimeout=5 )
