#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable-next=consider-using-from-import
import CliPlugin.TechSupportCli as TechSupportCli

#---------------------------------------------------------------------------
# 'show tech-support extended flow-spec'
# include 'show flow-spec ipv4', 'show flow-spec ipv6'
#--------------------------------------------------------------------------
TechSupportCli.registerShowTechSupportCmd(
   '2018-09-25 15:12:00',
   cmds=[ 'show flow-spec ipv4 vrf all summary',
          'show flow-spec ipv6 vrf all summary',
          'show flow-spec ipv4 vrf all',
          'show flow-spec ipv6 vrf all',
          'show hardware capacity',
          'show platform fap tcam summary',
          'show platform fap acl tcam hw' ],
   extended='flow-spec' )

#---------------------------------------------------------------------------
# 'show tech-support' and 'show tech-support summary'
# include 'show flow-spec ipv4 summary', 'show flow-spec ipv6 summary'
#--------------------------------------------------------------------------
TechSupportCli.registerShowTechSupportCmd(
   '2018-09-25 15:12:00',
   cmds=[ 'show flow-spec ipv4 vrf all summary',
          'show flow-spec ipv6 vrf all summary' ],
   summaryCmds=[ 'show flow-spec ipv4 vrf all summary',
                 'show flow-spec ipv6 vrf all summary' ] )
