#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import CliPlugin.AssetTags as AssetTags # pylint: disable=consider-using-from-import
from CliPlugin.AssetTagsModel import Assets
import CliPlugin.FwdChips as FwdChips # pylint: disable=consider-using-from-import
from CliPlugin.FwdChipsModel import ForwardingChipsModel
from CliPlugin.FruCli import SwitchOrModuleExpression
import ShowCommand
from CliToken.Hardware import hardwareMatcherForShow
from CliToken.System import systemMatcherForHardwareSystem

#--------------------------------------------------------------------------------
# show hardware asset-tag [ MODULE ]
#--------------------------------------------------------------------------------
class HardwareAssetTagCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show hardware asset-tag [ MODULE ]'
   data = {
      'hardware' : hardwareMatcherForShow,
      'asset-tag' : 'User-specified asset tags/IDs',
      'MODULE' : SwitchOrModuleExpression,
   }

   handler = AssetTags.doShowAssetTag
   cliModel = Assets

BasicCli.addShowCommandClass( HardwareAssetTagCmd )

# --------------------------------------------------------------------------------
# show hardware system forwarding-chips
# --------------------------------------------------------------------------------
class HardwareSystemFwdChipsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show hardware system forwarding-chips'
   data = {
      'hardware': hardwareMatcherForShow,
      'system': systemMatcherForHardwareSystem,
      'forwarding-chips': 'Forwarding chips details',
   }

   handler = FwdChips.doShowFwdChips
   cliModel = ForwardingChipsModel

BasicCli.addShowCommandClass( HardwareSystemFwdChipsCmd )
