# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliMatcher
import CliParser
import CliPlugin.FsfCli as FsfCli # pylint: disable=consider-using-from-import
import CliPlugin.IntfCli as IntfCli # pylint: disable=consider-using-from-import
import ConfigMount
import Tac

config = None

class FsfIntf( IntfCli.IntfDependentBase ):
   def setDefault( self ):
      del config.portConfig[ Tac.Value( "Arnet::IntfId", self.intf_.name ) ]

class FsfIntfModelet( CliParser.Modelet ):
   @staticmethod
   def shouldAddModeletRule( mode ):
      intfName = mode.intf.name
      return ( ( intfName.startswith( "Port-Channel" ) or
                 intfName.startswith( "Ethernet" ) ) and
               not mode.intf.isSubIntf() )

IntfCli.IntfConfigMode.addModelet( FsfIntfModelet )

def setPortFsf( mode, default=None ):
   intfId = mode.intf.name
   if intfId not in config.portConfig:
      config.portConfig.newMember( intfId )
   portConfig = config.portConfig[ intfId ]
   portConfig.enabled = not default

#--------------------------------------------------------------------------------
# [ no | default ] monitor server-failure link
#--------------------------------------------------------------------------------
class MonitorServerFailureLinkCmd( CliCommand.CliCommandClass ):
   syntax = 'monitor server-failure link'
   noOrDefaultSyntax = syntax
   data = {
      'monitor': 'Configure monitoring',
      'server-failure': CliCommand.Node(
         matcher=CliMatcher.KeywordMatcher( 'server-failure',
            helpdesc='Enable server-failure monitoring' ),
         guard=FsfCli.fsfGuard ),
      'link': 'Enable monitoring on this interface',
   }

   handler = lambda mode, args: setPortFsf( mode, default=False )
   noOrDefaultHandler= lambda mode, args: setPortFsf( mode, default=True )

FsfIntfModelet.addCommandClass( MonitorServerFailureLinkCmd )

def Plugin( entityManager ):
   global config
   config = ConfigMount.mount( entityManager, "fastserverfailover/config",
                             "FastServerFailover::Config", "w" )
   IntfCli.Intf.registerDependentClass( FsfIntf )
