# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import LazyMount
from CliPlugin import FwdChipsModel

entmib = None

def doShowFwdChips( mode, args ):
   fwdChips = FwdChipsModel.ForwardingChipsModel()
   if entmib.root is None:
      return fwdChips
   # Fabric chips will have chipIDs [ 10000 - 10999 ]
   # Switch chips will have chipIDs [ 11000 - 11999 ]
   # See EntityMib/EntityMibUtil.tin -> getChipId()

   def getFwdAgent( chipVer ):
      # Strata chip numbers start with 56
      # WH3+ is Strata and it starts with 53
      # Sand chip numbers start with 88
      if chipVer.startswith( "56" ) or \
         chipVer.startswith( "78" ) or \
         chipVer.startswith( "53" ):
         return "Strata"
      elif chipVer.startswith( "88" ):
         return "Sand"
      else:
         return "Other"

   def updateFwdChipsList( slotLabel, chip ):
      chipPos = int( chip.relPos )
      if 10000 <= chipPos < 12000 and chip.firmwareRev:
         idx = slotLabel + "-" + chip.tag
         chipLabel = chip.tag
         chipName = chip.modelName
         chipVer = chip.firmwareRev.split()[ 0 ]
         fwdAgent = getFwdAgent( chipVer )
         fwdChips.chips[ idx ] = FwdChipsModel.ForwardingChip(
                                       slotLabel=slotLabel,
                                       chipLabel=chipLabel,
                                       chipVer=chipVer,
                                       chipName=chipName,
                                       forwardingAgent=fwdAgent )
   if entmib.chassis:
      cardMibs = [ slot.card for slot in entmib.root.cardSlot.values() if slot.card ]
      for cm in cardMibs:
         # pylint: disable-next=consider-using-f-string
         slotLabel = "%s%s" % ( cm.tag, cm.label )
         for chip in cm.chip.values():
            updateFwdChipsList( slotLabel, chip )
   else:
      slotLabel = "Switch"
      for chip in entmib.root.chip.values():
         updateFwdChipsList( slotLabel, chip )

   return fwdChips

def Plugin( em ):
   global entmib
   entmib = LazyMount.mount( em, 'hardware/entmib', 'EntityMib::Status', 'r' )
