#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
from CliPlugin.RouterIgmp import RouterIgmpMode, RouterIgmpVrfMode
from CliPlugin.IgmpGlobalConfigMode import addRouterIgmpVrfModeHook
from CliPlugin.IgmpGlobalConfigMode import deleteRouterIgmpVrfModeHook
from CliPlugin.VrfCli import vrfExists, VrfExprFactory, RESERVED_VRF_NAMES
from CliPlugin import IraIpCli

#--------------------------------------------------------------------------------
# [ no | default ] vrf VRF
#--------------------------------------------------------------------------------
class VrfCmd( CliCommand.CliCommandClass ):
   syntax = 'VRF'
   noOrDefaultSyntax = syntax
   data = {
      'VRF' : VrfExprFactory( helpdesc='Configure IGMP in a VRF' ),
   }
   @staticmethod
   def handler( mode, args ):
      vrfName = args[ 'VRF' ]
      if vrfName in RESERVED_VRF_NAMES:
         # pylint: disable-next=consider-using-f-string
         mode.addError( "vrf name %s is reserved." % vrfName )
         return
      if not vrfExists( vrfName ):
         # pylint: disable-next=consider-using-f-string
         mode.addWarning( "vrf name %s is not defined." % vrfName )
      IraIpCli.warnIfRoutingDisabled( mode, vrfName )
      childMode = mode.childMode( RouterIgmpVrfMode, vrfName=vrfName )
      mode.session_.gotoChildMode( childMode )
      addRouterIgmpVrfModeHook.notifyExtensions( vrfName )
   
   @staticmethod
   def noOrDefaultHandler(  mode, args ):
      vrfName = args[ 'VRF' ]
      deleteRouterIgmpVrfModeHook.notifyExtensions( mode, vrfName )

RouterIgmpMode.addCommandClass( VrfCmd )

