# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CEosHelper import isCeos
import CliMatcher
import CliParser
# ----------------------------------------------------------------------------------
#                                K E Y W O R D S
# ----------------------------------------------------------------------------------
def icmpErrExtPlatformGuard( mode, token ):
   if isCeos():
      # Feature implementation includes an EBPF krobe program
      # which is not namespaced. We don't want to enable this on cEOS
      # as we don't have control over host kernel or host.
      return CliParser.guardNotThisPlatform
   return None

matcherIcmp = CliMatcher.KeywordMatcher(
      'icmp',
      'ICMP/ICMPv6' )
matcherIcmpError = CliMatcher.KeywordMatcher(
      'error',
      'ICMP/ICMPv6 error response' )
matcherIcmpErrorExtensions = CliMatcher.KeywordMatcher(
      'extensions',
      'ICMP/ICMPv6 error extensions (rfc5837)' )
