# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import AgentDirectory
import LazyMount

from CliPlugin.TechSupportCli import registerShowTechSupportCmd
from Toggles.IcmpResponderToggleLib import (
      toggleIcmpExtendedErrorResponderEnabled,
      toggleIcmpProbeResponderEnabled )

probeResponderCmds = [ "show icmp probe" ]
errorResponderCmds = [
      "show icmp error extensions",
      "show icmp error extensions counters",
]
commonCmds = [
      "show agent IcmpResponder task scheduler",
]

timestamp1 = '2024-07-16 12:14:00'
em = None
errorConfig = None
probeConfig = None

def errorResponderShowTechGuard():
   assert errorConfig
   return ( errorConfig.enabled.isSet or
            bool( errorConfig.vrfConfig ) )

def probeResponderShowTechGuard():
   assert probeConfig
   return probeConfig.enabled

def icmpResponderShowTechGuard():
   assert em
   return bool( AgentDirectory.agent( em.sysname(), 'IcmpResponder' ) )

if toggleIcmpExtendedErrorResponderEnabled():
   registerShowTechSupportCmd( timestamp1,
                               cmds=errorResponderCmds,
                               cmdsGuard=errorResponderShowTechGuard )

if toggleIcmpProbeResponderEnabled():
   registerShowTechSupportCmd( timestamp1,
                               cmds=probeResponderCmds,
                               cmdsGuard=probeResponderShowTechGuard )

if toggleIcmpExtendedErrorResponderEnabled() or \
      toggleIcmpProbeResponderEnabled():
   registerShowTechSupportCmd( timestamp1,
                               cmds=commonCmds,
                               cmdsGuard=icmpResponderShowTechGuard )

def Plugin( entityManager ):
   global em, errorConfig, probeConfig
   em = entityManager
   errorConfig = LazyMount.mount( entityManager,
                                  'icmp/errorResponder/config',
                                  'IcmpResponder::ErrorResponder::Config', 'r' )
   probeConfig = LazyMount.mount( entityManager, 'icmp/probe/config',
                                  'IcmpResponder::ProbeResponder::Config', 'w' )
