# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import ConfigMount
import LazyMount
from CliParser import guardNotThisPlatform

igdConfig = None
natHwCapabilities = None

def getIgdConfig():
   return igdConfig

def getIgdVrfConfig( vrfName ):
   return igdConfig.igdVrfConfig.newMember( vrfName )

def upnpIgdSupportedGuard( mode, token ):
   # Check if UPNP port mapping is supported
   if natHwCapabilities.natUpnpPortMapSupported:
      return None
   return guardNotThisPlatform

def Plugin( entityManager ):
   global igdConfig, natHwCapabilities

   igdConfig = ConfigMount.mount( entityManager,
         'upnp/igd/config', 'IgdUpnp::Config', 'w' )

   natHwCapabilities = LazyMount.mount( entityManager,
         'ip/nat/hwCapabilities', 'Ip::Nat::HwCapabilities', 'r' )
